/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;

public class CASTFieldDeclarator
extends CASTDeclarator
implements IASTFieldDeclarator {
    private IASTExpression bitFieldSize;

    public CASTFieldDeclarator() {
    }

    public CASTFieldDeclarator(IASTName name, IASTExpression bitFieldSize) {
        super(name);
        this.setBitFieldSize(bitFieldSize);
    }

    public CASTFieldDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTFieldDeclarator copy(IASTNode.CopyStyle style) {
        CASTFieldDeclarator copy = new CASTFieldDeclarator();
        this.copyBaseDeclarator(copy, style);
        copy.setBitFieldSize(this.bitFieldSize == null ? null : this.bitFieldSize.copy(style));
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTExpression getBitFieldSize() {
        return this.bitFieldSize;
    }

    public void setBitFieldSize(IASTExpression size) {
        this.assertNotFrozen();
        this.bitFieldSize = size;
        if (size != null) {
            size.setParent(this);
            size.setPropertyInParent(FIELD_SIZE);
        }
    }

    protected boolean postAccept(ASTVisitor action) {
        if (this.bitFieldSize != null && !this.bitFieldSize.accept(action)) {
            return false;
        }
        return super.postAccept(action);
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.bitFieldSize) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.bitFieldSize = (IASTExpression)other;
        } else {
            super.replace(child, other);
        }
    }
}

