/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;

public class CPPASTSimpleTypeConstructorExpression
extends ASTNode
implements ICPPASTSimpleTypeConstructorExpression {
    private ICPPASTDeclSpecifier fDeclSpec;
    private IASTInitializer fInitializer;
    private IType fType;

    public CPPASTSimpleTypeConstructorExpression() {
    }

    public CPPASTSimpleTypeConstructorExpression(ICPPASTDeclSpecifier declSpec, IASTInitializer init) {
        this.setDeclSpecifier(declSpec);
        this.setInitializer(init);
    }

    public CPPASTSimpleTypeConstructorExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CPPASTSimpleTypeConstructorExpression copy(IASTNode.CopyStyle style) {
        CPPASTSimpleTypeConstructorExpression copy = new CPPASTSimpleTypeConstructorExpression();
        copy.setDeclSpecifier(this.fDeclSpec == null ? null : this.fDeclSpec.copy(style));
        copy.setInitializer(this.fInitializer == null ? null : this.fInitializer.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public ICPPASTDeclSpecifier getDeclSpecifier() {
        return this.fDeclSpec;
    }

    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    public void setDeclSpecifier(ICPPASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.fDeclSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(TYPE_SPECIFIER);
        }
    }

    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.fInitializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    public IType getExpressionType() {
        if (this.fType == null) {
            this.fType = ExpressionTypes.prvalueType(CPPVisitor.createType(this.fDeclSpec));
        }
        return this.fType;
    }

    public boolean isLValue() {
        return false;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclSpec != null && !this.fDeclSpec.accept(action)) {
            return false;
        }
        if (this.fInitializer != null && !this.fInitializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Deprecated
    public int getSimpleType() {
        IType type = this.getExpressionType();
        if (type instanceof ICPPBasicType) {
            ICPPBasicType bt = (ICPPBasicType)type;
            IBasicType.Kind kind = bt.getKind();
            switch (kind) {
                case eBoolean: {
                    return 6;
                }
                case eChar: {
                    return 2;
                }
                case eDouble: {
                    return 5;
                }
                case eFloat: {
                    return 4;
                }
                case eInt: {
                    if (bt.isShort()) {
                        return 8;
                    }
                    if (bt.isLong()) {
                        return 9;
                    }
                    if (bt.isSigned()) {
                        return 10;
                    }
                    if (bt.isUnsigned()) {
                        return 11;
                    }
                    return 3;
                }
                case eVoid: {
                    return 1;
                }
                case eWChar: {
                    return 7;
                }
            }
        }
        return 0;
    }

    @Deprecated
    public void setSimpleType(int value) {
        CPPASTSimpleDeclSpecifier declspec = new CPPASTSimpleDeclSpecifier();
        switch (value) {
            case 6: {
                declspec.setType(IBasicType.Kind.eBoolean);
                break;
            }
            case 2: {
                declspec.setType(IBasicType.Kind.eChar);
                break;
            }
            case 5: {
                declspec.setType(IBasicType.Kind.eDouble);
                break;
            }
            case 4: {
                declspec.setType(IBasicType.Kind.eFloat);
                break;
            }
            case 3: {
                declspec.setType(IBasicType.Kind.eInt);
                break;
            }
            case 9: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setLong(true);
                break;
            }
            case 8: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setShort(true);
                break;
            }
            case 10: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setSigned(true);
                break;
            }
            case 11: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setUnsigned(true);
                break;
            }
            case 1: {
                declspec.setType(IBasicType.Kind.eVoid);
                break;
            }
            case 7: {
                declspec.setType(IBasicType.Kind.eWChar);
                break;
            }
            default: {
                declspec.setType(IBasicType.Kind.eUnspecified);
            }
        }
        this.setDeclSpecifier(declspec);
    }

    @Deprecated
    public IASTExpression getInitialValue() {
        if (this.fInitializer instanceof ICPPASTConstructorInitializer) {
            return ((ICPPASTConstructorInitializer)this.fInitializer).getExpression();
        }
        return null;
    }

    @Deprecated
    public void setInitialValue(IASTExpression expression) {
        CPPASTConstructorInitializer init = new CPPASTConstructorInitializer();
        init.setExpression(expression);
        this.setInitializer(init);
    }
}

