/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPFunctionSpecialization
extends CPPSpecialization
implements ICPPFunction,
ICPPInternalFunction {
    private ICPPFunctionType type = null;
    private ICPPParameter[] fParams = null;
    private IType[] specializedExceptionSpec = null;

    public CPPFunctionSpecialization(ICPPFunction orig, IBinding owner, ICPPTemplateParameterMap argMap) {
        super(orig, owner, argMap);
    }

    private ICPPFunction getFunction() {
        return (ICPPFunction)this.getSpecializedBinding();
    }

    public ICPPParameter[] getParameters() {
        if (this.fParams == null) {
            ICPPFunction function = this.getFunction();
            ICPPParameter[] params = function.getParameters();
            if (params.length == 0) {
                this.fParams = params;
            } else {
                ICPPTemplateParameterMap tparMap = this.getTemplateParameterMap();
                IType[] ptypes = this.getType().getParameterTypes();
                int length = ptypes.length;
                ICPPParameter par = null;
                this.fParams = new ICPPParameter[length];
                int i = 0;
                while (i < length) {
                    if (i < params.length) {
                        par = params[i];
                    }
                    this.fParams[i] = new CPPParameterSpecialization(par, this, ptypes[i], tparMap);
                    ++i;
                }
            }
        }
        return this.fParams;
    }

    public int getRequiredArgumentCount() {
        return ((ICPPFunction)this.getSpecializedBinding()).getRequiredArgumentCount();
    }

    public boolean hasParameterPack() {
        return ((ICPPFunction)this.getSpecializedBinding()).hasParameterPack();
    }

    public IScope getFunctionScope() {
        return null;
    }

    public ICPPFunctionType getType() {
        if (this.type == null) {
            ICPPFunction function = (ICPPFunction)this.getSpecializedBinding();
            this.type = (ICPPFunctionType)this.specializeType(function.getType());
        }
        return this.type;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isDeleted() {
        IASTNode def = this.getDefinition();
        if (def != null) {
            return CPPFunction.isDeletedDefinition(def);
        }
        IBinding f = this.getSpecializedBinding();
        if (f instanceof ICPPFunction) {
            return ((ICPPFunction)f).isDeleted();
        }
        return false;
    }

    public boolean isInline() {
        if (this.getDefinition() != null) {
            IASTNode def = this.getDefinition();
            while (!(def instanceof IASTFunctionDefinition)) {
                def = def.getParent();
            }
            return ((IASTFunctionDefinition)def).getDeclSpecifier().isInline();
        }
        return this.getFunction().isInline();
    }

    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        return this.getFunction().isExternC();
    }

    public boolean isStatic() {
        return this.isStatic(true);
    }

    public boolean isStatic(boolean resolveAll) {
        IBinding f = this.getSpecializedBinding();
        if (f instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)f).isStatic(resolveAll);
        }
        if (f instanceof IIndexBinding && f instanceof ICPPFunction) {
            return ((ICPPFunction)f).isStatic();
        }
        return CPPFunction.hasStorageClass(this, 3);
    }

    public boolean isExtern() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isExtern();
        }
        return CPPFunction.hasStorageClass(this, 2);
    }

    public boolean isAuto() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isAuto();
        }
        return CPPFunction.hasStorageClass(this, 4);
    }

    public boolean isRegister() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.isRegister();
        }
        return CPPFunction.hasStorageClass(this, 5);
    }

    public boolean takesVarArgs() {
        ICPPFunction f = (ICPPFunction)this.getSpecializedBinding();
        if (f != null) {
            return f.takesVarArgs();
        }
        ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)this.getDefinition();
        if (dtor != null) {
            return dtor.takesVarArgs();
        }
        ICPPASTFunctionDeclarator[] ds = (ICPPASTFunctionDeclarator[])this.getDeclarations();
        if (ds != null && ds.length > 0) {
            return ds[0].takesVarArgs();
        }
        return false;
    }

    public IBinding resolveParameter(CPPParameter param) {
        int pos = param.getParameterPosition();
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen) {
            block4: {
                ICPPASTParameterDeclaration[] params;
                ICPPASTFunctionDeclarator tdecl;
                block3: {
                    block2: {
                        if (i != -1) break block2;
                        tdecl = (ICPPASTFunctionDeclarator)this.getDefinition();
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    if (decls == null || (tdecl = (ICPPASTFunctionDeclarator)decls[i]) == null) break;
                }
                if (pos < (params = tdecl.getParameters()).length) {
                    IASTName oName = this.getParamName(params[pos]);
                    return oName.resolvePreBinding();
                }
            }
            ++i;
        }
        return param;
    }

    protected void updateFunctionParameterBindings(ICPPASTFunctionDeclarator fdtor) {
        ICPPASTParameterDeclaration[] updateParams = fdtor.getParameters();
        int k = 0;
        IASTNode[] decls = this.getDeclarations();
        int tdeclLen = decls == null ? 0 : decls.length;
        int i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block4: {
                ICPPASTFunctionDeclarator tdecl;
                block3: {
                    block2: {
                        if (i != -1) break block2;
                        tdecl = (ICPPASTFunctionDeclarator)this.getDefinition();
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    if (decls == null || (tdecl = (ICPPASTFunctionDeclarator)decls[i]) == null) break;
                }
                ICPPASTParameterDeclaration[] params = tdecl.getParameters();
                int end = Math.min(params.length, updateParams.length);
                while (k < end) {
                    IASTName oName = this.getParamName(params[k]);
                    IBinding b = oName.resolvePreBinding();
                    IASTName n = this.getParamName(updateParams[k]);
                    n.setBinding(b);
                    ASTInternal.addDeclaration(b, n);
                    ++k;
                }
            }
            ++i;
        }
    }

    private IASTName getParamName(IASTParameterDeclaration paramDecl) {
        return ASTQueries.findInnermostDeclarator(paramDecl.getDeclarator()).getName();
    }

    private ICPPASTFunctionDeclarator extractFunctionDtor(IASTNode node) {
        if (node instanceof IASTName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        if (!((node = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)node)) instanceof ICPPASTFunctionDeclarator)) {
            return null;
        }
        return (ICPPASTFunctionDeclarator)node;
    }

    public void addDefinition(IASTNode node) {
        ICPPASTFunctionDeclarator dtor = this.extractFunctionDtor(node);
        if (dtor != null) {
            this.updateFunctionParameterBindings(dtor);
            super.addDefinition(dtor);
        }
    }

    public void addDeclaration(IASTNode node) {
        ICPPASTFunctionDeclarator dtor = this.extractFunctionDtor(node);
        if (dtor != null) {
            this.updateFunctionParameterBindings(dtor);
            super.addDeclaration(dtor);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        ICPPFunctionType t = this.getType();
        result.append(t != null ? ASTTypeUtil.getParameterTypeString(t) : "()");
        ICPPTemplateParameterMap tpmap = this.getTemplateParameterMap();
        if (tpmap != null) {
            result.append(" ");
            result.append(tpmap.toString());
        }
        return result.toString();
    }

    public IType[] getExceptionSpecification() {
        ICPPFunction function;
        IType[] types;
        if (this.specializedExceptionSpec == null && (types = (function = (ICPPFunction)this.getSpecializedBinding()).getExceptionSpecification()) != null) {
            IType[] specializedTypeList = new IType[types.length];
            int j = 0;
            int i = 0;
            while (i < types.length) {
                IType origType = types[i];
                if (origType instanceof ICPPParameterPackType) {
                    IType[] specialized = this.specializeTypePack((ICPPParameterPackType)origType);
                    if (specialized.length != 1) {
                        IType[] x = new IType[specializedTypeList.length + specialized.length - 1];
                        System.arraycopy(specializedTypeList, 0, x, 0, j);
                        specializedTypeList = x;
                    }
                    IType[] iTypeArray = specialized;
                    int n = specialized.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType iType = iTypeArray[n2];
                        specializedTypeList[j++] = iType;
                        ++n2;
                    }
                } else {
                    specializedTypeList[j++] = this.specializeType(origType);
                }
                ++i;
            }
            this.specializedExceptionSpec = specializedTypeList;
        }
        return this.specializedExceptionSpec;
    }
}

