/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICSettingObject;

public class CProjectDescriptionDelta
implements ICDescriptionDelta {
    private List<CProjectDescriptionDelta> fChildList = new ArrayList<CProjectDescriptionDelta>();
    private CProjectDescriptionDelta fParent;
    private ICSettingObject fSetting;
    private ICSettingObject fOldSetting;
    private ICSettingObject fNewSetting;
    private int fStatus;
    private int fAddedLanguageEntriesKinds;
    private int fRemovedLanguageEntriesKinds;
    private int fReorderedLanguageEntriesKinds;
    private static final int KIND_MASK = 3;
    private static final int FLAGS_OFFSET = 2;

    public CProjectDescriptionDelta(ICSettingObject newSetting, ICSettingObject oldSetting) {
        this.fNewSetting = newSetting;
        this.fOldSetting = oldSetting;
        if (newSetting != null) {
            this.fSetting = newSetting;
            if (oldSetting != null) {
                this.setDeltaKind(3);
            } else {
                this.setDeltaKind(2);
            }
        } else {
            this.fSetting = oldSetting;
            this.setDeltaKind(1);
        }
    }

    void addChild(CProjectDescriptionDelta child) {
        this.fChildList.add(child);
        child.setParent(this);
    }

    private void setParent(CProjectDescriptionDelta parent) {
        this.fParent = parent;
    }

    public ICDescriptionDelta[] getChildren() {
        return this.fChildList.toArray(new CProjectDescriptionDelta[this.fChildList.size()]);
    }

    public ICSettingObject getOldSetting() {
        return this.fOldSetting;
    }

    public ICSettingObject getSetting() {
        return this.fSetting;
    }

    public int getSettingType() {
        return this.fSetting.getType();
    }

    public ICDescriptionDelta getParent() {
        return this.fParent;
    }

    public boolean isEmpty() {
        return this.fChildList.size() == 0 && this.getDeltaKind() == 3 && this.getChangeFlags() == 0;
    }

    public int getChangeFlags() {
        return (this.fStatus & 0xFFFFFFFC) >> 2;
    }

    void addChangeFlags(int flags) {
        this.setChangeFlags(flags |= this.getChangeFlags());
    }

    void removeChangeFlags(int flags) {
        flags = this.getChangeFlags() & ~flags;
        this.setChangeFlags(flags);
    }

    void setChangeFlags(int flags) {
        this.fStatus = this.fStatus & 3 | flags << 2;
    }

    void setDeltaKind(int kind) {
        this.fStatus = this.fStatus & 0xFFFFFFFC | kind & 3;
    }

    public int getDeltaKind() {
        return this.fStatus & 3;
    }

    public ICSettingObject getNewSetting() {
        return this.fNewSetting;
    }

    void setAddedLanguageEntriesKinds(int kinds) {
        this.fAddedLanguageEntriesKinds = kinds;
        this.checkSettingEntriesChangeFlag();
    }

    public int getAddedEntriesKinds() {
        return this.fAddedLanguageEntriesKinds;
    }

    public int getRemovedEntriesKinds() {
        return this.fRemovedLanguageEntriesKinds;
    }

    public int getReorderedEntriesKinds() {
        return this.fReorderedLanguageEntriesKinds;
    }

    void setRemovedLanguageEntriesKinds(int kinds) {
        this.fRemovedLanguageEntriesKinds = kinds;
        this.checkSettingEntriesChangeFlag();
    }

    void setReorderedLanguageEntriesKinds(int kinds) {
        this.fReorderedLanguageEntriesKinds = kinds;
        this.checkSettingEntriesChangeFlag();
    }

    private void checkSettingEntriesChangeFlag() {
        if (this.fAddedLanguageEntriesKinds != 0 || this.fRemovedLanguageEntriesKinds != 0 || this.fReorderedLanguageEntriesKinds != 0) {
            this.addChangeFlags(512);
        } else {
            this.removeChangeFlags(512);
        }
    }

    private static String flagsToString(int flags) {
        StringBuilder str = new StringBuilder();
        str.append(", flags=0x" + Integer.toHexString(flags));
        str.append(":");
        if ((flags & 1) != 0) {
            str.append("ACTIVE_CFG|");
        }
        if ((flags & 2) != 0) {
            str.append("NAME|");
        }
        if ((flags & 4) != 0) {
            str.append("DESCRIPTION|");
        }
        if ((flags & 0x10) != 0) {
            str.append("LANGUAGE_ID|");
        }
        if ((flags & 0x20) != 0) {
            str.append("SOURCE_CONTENT_TYPE|");
        }
        if ((flags & 0x40) != 0) {
            str.append("SOURCE_ENTENSIONS|");
        }
        if ((flags & 0x200) != 0) {
            str.append("SETTING_ENTRIES|");
        }
        if ((flags & 0x400) != 0) {
            str.append("BINARY_PARSER_IDS|");
        }
        if ((flags & 0x800) != 0) {
            str.append("ERROR_PARSER_IDS|");
        }
        if ((flags & 0x1000) != 0) {
            str.append("EXCLUDE|");
        }
        if ((flags & 0x2000) != 0) {
            str.append("SOURCE_ADDED|");
        }
        if ((flags & 0x4000) != 0) {
            str.append("SOURCE_REMOVED|");
        }
        if ((flags & 0x8000) != 0) {
            str.append("EXTERNAL_SETTINGS_ADDED|");
        }
        if ((flags & 0x10000) != 0) {
            str.append("EXTERNAL_SETTINGS_REMOVED|");
        }
        if ((flags & 0x20000) != 0) {
            str.append("CFG_REF_ADDED|");
        }
        if ((flags & 0x40000) != 0) {
            str.append("CFG_REF_REMOVED|");
        }
        if ((flags & 0x80000) != 0) {
            str.append("EXT_REF|");
        }
        if ((flags & 0x100000) != 0) {
            str.append("OWNER|");
        }
        if ((flags & 0x200000) != 0) {
            str.append("INDEX_CFG|");
        }
        if (str.charAt(str.length() - 1) == '|') {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String type = this.fSetting.getClass().getSimpleName();
        str.append("[" + type + "]");
        int kind = this.getDeltaKind();
        str.append(", kind=" + kind);
        switch (kind) {
            case 2: {
                str.append(":ADDED");
                break;
            }
            case 1: {
                str.append(":REMOVED");
                break;
            }
            case 3: {
                str.append(":CHANGED");
                break;
            }
            default: {
                str.append(":<unknown>");
            }
        }
        str.append(CProjectDescriptionDelta.flagsToString(this.getChangeFlags()));
        ICDescriptionDelta[] children = this.getChildren();
        if (children == null) {
            str.append(", no children");
        } else {
            str.append(", " + this.getChildren().length + " children");
        }
        return str.toString();
    }
}

