/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.io.ByteArrayOutputStream;
import org.tizen.dynamicanalyzer.util.ByteUtil;

public class ProtocolSerializer {
    int msgID = 0;
    private ByteArrayOutputStream payload = new ByteArrayOutputStream();

    public ProtocolSerializer() {
        this.payload.reset();
    }

    public void setMessageID(int msgID) {
        this.msgID = msgID;
    }

    public void putByte(byte val) {
        byte[] buf = new byte[]{val};
        this.payload.write(buf, 0, buf.length);
    }

    public void putShort(short val) {
        byte[] buf = ByteUtil.toBytes((short)val);
        this.payload.write(buf, 0, buf.length);
    }

    public void putInt(int val) {
        byte[] buf = ByteUtil.toBytes((int)val);
        this.payload.write(buf, 0, buf.length);
    }

    public void putLong(long val) {
        byte[] buf = ByteUtil.toBytes((long)val);
        this.payload.write(buf, 0, buf.length);
    }

    public void putFloat(float val) {
        byte[] buf = ByteUtil.toBytes((float)val);
        this.payload.write(buf, 0, buf.length);
    }

    public void putDouble(double val) {
        byte[] buf = ByteUtil.toBytes((double)val);
        this.payload.write(buf, 0, buf.length);
    }

    public void putString(String val) {
        byte[] buf = ByteUtil.toByte((String)val);
        this.payload.write(buf, 0, buf.length);
    }

    public void putByteArray(byte[] val) {
        this.payload.write(val, 0, val.length);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] buf = ByteUtil.toBytes((int)this.msgID);
        stream.write(buf, 0, buf.length);
        int count = this.payload.size();
        buf = ByteUtil.toBytes((int)count);
        stream.write(buf, 0, buf.length);
        if (count > 0) {
            buf = this.payload.toByteArray();
            stream.write(buf, 0, buf.length);
        }
        return stream.toByteArray();
    }
}

