/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.tizen.dynamicanalyzer.util.Logger;

public enum SideWorker implements Runnable
{
    INSTANCE;

    private Thread thread = null;
    private BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();

    public void start() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(null, INSTANCE, "Side worker thread");
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(5000L);
            }
            catch (InterruptedException e) {
                Logger.exception((Throwable)e);
            }
        }
        this.thread = null;
    }

    public void offerWork(Runnable work) {
        if (work != null) {
            this.workQueue.offer(work);
        }
    }

    @Override
    public void run() {
        while (!this.thread.isInterrupted()) {
            Runnable runnable = null;
            try {
                runnable = this.workQueue.take();
            }
            catch (InterruptedException interruptedException) {
                Logger.debug((Object)"expected interrupt exception");
                break;
            }
            if (runnable == null) continue;
            runnable.run();
        }
        Logger.debug((Object)"Side worker thread is terminated");
    }
}

