/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol.p41;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.protocol.IProtocolConfig;
import org.tizen.dynamicanalyzer.setting.FlatFeature;
import org.tizen.dynamicanalyzer.setting.FlatPreferences;
import org.tizen.dynamicanalyzer.util.ByteUtil;

public enum ProtocolConfig41 implements IProtocolConfig
{
    RESERVED1(0),
    RESERVED2(1),
    FUNCTION_PROFILING(2),
    MEMORY_ALLOC_PROBE(3),
    FILE_API_PROBE(4),
    THREAD_API_PROBE(5),
    OSPUI_API_PROBE(6),
    SCREENSHOT(7),
    USER_EVENT(8),
    RECORDING(9),
    SYSCALL_FILE(10),
    SYSCALL_IPC(11),
    SYSCALL_PROCESS(12),
    SYSCALL_SIGNAL(13),
    SYSCALL_NETWORK(14),
    SYSCALL_DESC(15),
    CONTEXT_SWITCH(16),
    NETWORK_API_PROBE(17),
    OPENGL_API_PROBE(18),
    FUNCTION_SAMPLING(19),
    INTERNAL_MEMORY_ALLOC(28),
    INTERNAL_FILE_API(29),
    INTERNAL_THREAD_API(30),
    INTERNAL_OSPUI_API(31),
    INTERNAL_NETWORK_API(32),
    INTERNAL_OPENGL_API(33),
    SYSTEM_CPU(36),
    SYSTEM_MEMORY(37),
    SYSTEM_PROCESS(38),
    SYSTEM_THREAD_LOAD(39),
    SYSTEM_PROCESSES_LOAD(40),
    SYSTEM_DISK(41),
    SYSTEM_NETWORK(42),
    SYSTEM_DEVICE(43),
    SYSTEM_ENERGY(44),
    APP_STARTUP(45),
    WEB_FUNCTION_PROFILING(46),
    WEBAPP_STARTUP(47),
    NONTARGET_FILE_ACTIVITY(48),
    UI_HIERARCHY(49),
    LEAK_SANITIZER(50);

    private static final Map<FlatPreferences, ProtocolConfig41[]> preferencesProtocolMap;
    private static final Map<FlatFeature, ProtocolConfig41[]> flatFeatureProtocolMap;
    private int bitShift;

    static {
        EnumMap<Enum, ProtocolConfig41[]> tempMap = new EnumMap<FlatPreferences, ProtocolConfig41[]>(FlatPreferences.class);
        tempMap.put(FlatPreferences.RECORDING, new ProtocolConfig41[]{RECORDING});
        tempMap.put(FlatPreferences.FUNCTION_PROFILING, new ProtocolConfig41[]{FUNCTION_PROFILING, WEB_FUNCTION_PROFILING});
        tempMap.put(FlatPreferences.FUNCTION_SAMPLING_RATE, new ProtocolConfig41[]{FUNCTION_SAMPLING});
        tempMap.put(FlatPreferences.APP_STARTUP, new ProtocolConfig41[]{APP_STARTUP, WEBAPP_STARTUP});
        tempMap.put(FlatPreferences.SYSTEM_ALL_PROCESSES, new ProtocolConfig41[]{SYSTEM_PROCESSES_LOAD});
        tempMap.put(FlatPreferences.PROCESS_MEMORY, new ProtocolConfig41[]{SYSTEM_PROCESS});
        tempMap.put(FlatPreferences.SCREENSHOT_ON_SCENE_TRANSITION, new ProtocolConfig41[]{SCREENSHOT, OSPUI_API_PROBE});
        tempMap.put(FlatPreferences.LEAK_SANITIZER, new ProtocolConfig41[]{LEAK_SANITIZER});
        preferencesProtocolMap = Collections.unmodifiableMap(tempMap);
        tempMap = new EnumMap(FlatFeature.class);
        tempMap.put((FlatPreferences)((Object)FlatFeature.CPU_USAGE), new ProtocolConfig41[]{SYSTEM_CPU});
        tempMap.put(FlatFeature.CPU_USAGE_PER_CORE, new ProtocolConfig41[]{SYSTEM_CPU});
        tempMap.put(FlatFeature.CPU_FREQ_PER_CORE, new ProtocolConfig41[]{SYSTEM_CPU});
        tempMap.put(FlatFeature.SYSTEM_MEMORY, new ProtocolConfig41[]{SYSTEM_MEMORY});
        tempMap.put(FlatFeature.PROCESS_MEMORY, new ProtocolConfig41[]{SYSTEM_PROCESS});
        tempMap.put(FlatFeature.MEMORY_ALLOC, new ProtocolConfig41[]{INTERNAL_MEMORY_ALLOC});
        tempMap.put(FlatFeature.DISK_IO, new ProtocolConfig41[]{SYSTEM_DISK});
        tempMap.put(FlatFeature.FILE_ANALYSIS, new ProtocolConfig41[]{FILE_API_PROBE, NONTARGET_FILE_ACTIVITY});
        tempMap.put(FlatFeature.OPENGLES_ANALYSIS, new ProtocolConfig41[]{OPENGL_API_PROBE});
        tempMap.put(FlatFeature.NETWORK_IO, new ProtocolConfig41[]{SYSTEM_NETWORK});
        tempMap.put(FlatFeature.NETWORK_ANALYSIS, new ProtocolConfig41[]{NETWORK_API_PROBE});
        tempMap.put(FlatFeature.UI_EVENT, new ProtocolConfig41[]{USER_EVENT});
        tempMap.put(FlatFeature.UI_HIERARCHY_ANALYSIS, new ProtocolConfig41[]{UI_HIERARCHY});
        tempMap.put(FlatFeature.THREAD_ANALYSIS, new ProtocolConfig41[]{THREAD_API_PROBE, SYSTEM_THREAD_LOAD});
        tempMap.put(FlatFeature.PERIPHERAL_STATUS, new ProtocolConfig41[]{SYSTEM_DEVICE});
        tempMap.put(FlatFeature.POWER_ESTIMATION, new ProtocolConfig41[]{SYSTEM_ENERGY});
        flatFeatureProtocolMap = Collections.unmodifiableMap(tempMap);
    }

    private ProtocolConfig41(int bitshift) {
        this.bitShift = bitshift;
    }

    @Override
    public int getShift() {
        return this.bitShift;
    }

    public static byte[] getFlatFeatureFlagValue(Set<FlatFeature> flatFeatures, Set<FlatPreferences> selectedPreferences) {
        int bitshift;
        int i;
        ProtocolConfig41[] configs;
        long lowValue = 0L;
        long highValue = 0L;
        if (flatFeatures != null) {
            for (FlatFeature flatFeature : flatFeatures) {
                configs = flatFeatureProtocolMap.get((Object)flatFeature);
                if (configs == null) continue;
                i = 0;
                while (i < configs.length) {
                    bitshift = configs[i].getShift();
                    if (bitshift >= 64) {
                        highValue |= 1L << bitshift - 64;
                    } else {
                        lowValue |= 1L << bitshift;
                    }
                    ++i;
                }
            }
        }
        if (selectedPreferences != null) {
            for (FlatPreferences feature : selectedPreferences) {
                configs = preferencesProtocolMap.get((Object)feature);
                if (configs == null) continue;
                i = 0;
                while (i < configs.length) {
                    bitshift = configs[i].getShift();
                    if (bitshift >= 64) {
                        highValue |= 1L << bitshift - 64;
                    } else {
                        lowValue |= 1L << bitshift;
                    }
                    ++i;
                }
            }
        }
        byte[] lowbyte = ByteUtil.toBytes((long)lowValue);
        byte[] highbyte = ByteUtil.toBytes((long)highValue);
        byte[] ret = new byte[16];
        System.arraycopy(lowbyte, 0, ret, 0, 8);
        System.arraycopy(highbyte, 0, ret, 8, 8);
        return ret;
    }

    public static IProtocolConfig[] getProtocolConfig(FlatFeature feature) {
        return flatFeatureProtocolMap.get((Object)feature);
    }
}

