/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.communicator;

public enum SwapErrorCode {
    SUCCESS(0, "Success"),
    ERR_LOCKFILE_CREATE_FAILED(-101, "Lock file create failed"),
    ERR_ALREADY_RUNNING(-102, "Already running"),
    ERR_INITIALIZE_SYSTEM_INFO_FAILED(-103, "Initialize system info failed"),
    ERR_HOST_SERVER_SOCKET_CREATE_FAILED(-104, "host server socket create failed"),
    ERR_TARGET_SERVER_SOCKET_CREATE_FAILED(-105, "target server socket create failed"),
    ERR_WRONG_MESSAGE_FORMAT(-201, "Wrong message format"),
    ERR_WRONG_MESSAGE_TYPE(-202, "Wrong message type"),
    ERR_WRONG_MESSAGE_DATA(-203, "Wrong message data"),
    ERR_CANNOT_START_PROFILING(-204, "cannot start profiling"),
    ERR_UI_OBJECT_NOT_FOUND(-207, "Requested UI object is not found"),
    ERR_UI_OBJECT_CAN_NOT_TAKE_SCREENSHOT(-208, "Couldn't take screenshot because App is in background"),
    ERR_SER_SOCK_CREATE(-900, "Server socket creation failed"),
    ERR_SER_SOCK_BIND(-901, "Server socket bind failed"),
    ERR_SER_SOCK_LISTEN(-902, "Server socket listen failed"),
    ERR_NOT_DEFINED(-999, "Unknown error");

    private final String message;
    private final int errNo;

    private SwapErrorCode(int num, String msg) {
        this.errNo = num;
        this.message = msg;
    }

    public int getErrorNumber() {
        return this.errNo;
    }

    public String getMessage() {
        return this.message;
    }

    public static SwapErrorCode getError(int num) {
        SwapErrorCode[] errors = SwapErrorCode.values();
        int i = 0;
        while (i < errors.length) {
            if (errors[i].getErrorNumber() == num) {
                return errors[i];
            }
            ++i;
        }
        return ERR_NOT_DEFINED;
    }
}

