/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.logparser;

import java.util.HashMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.control.DataThread;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;

public abstract class PageDataManager
extends DataThread<LogPackage> {
    protected String name = null;
    private Map<String, DBInserter> insertThreads = new HashMap<String, DBInserter>();

    @Override
    protected String getThreadName() {
        return this.getName();
    }

    @Override
    protected boolean workAfterStart() {
        this.startInserters();
        return true;
    }

    @Override
    protected boolean workAfterStopNormal() {
        this.stopInsertersNormal();
        return true;
    }

    @Override
    protected boolean workAfterStopForced() {
        this.stopInsertersForced();
        return true;
    }

    @Override
    protected void resetBeforeStart() {
    }

    @Override
    protected void clearAfterStop() {
    }

    public static String getClassName(Class<?> mgrClass) {
        return mgrClass.getSimpleName();
    }

    public final String getName() {
        if (this.name == null) {
            this.name = PageDataManager.getClassName(this.getClass());
        }
        return this.name;
    }

    public final DBInserter makeInserter(DBTable table) {
        DBInserter ret = null;
        String tablename = table.getTableName();
        if (!this.insertThreads.containsKey(tablename)) {
            DBInserter thread = new DBInserter(table);
            table.setDBInserter(thread);
            this.insertThreads.put(tablename, thread);
            ret = thread;
        } else {
            ret = this.insertThreads.get(tablename);
        }
        return ret;
    }

    public final DBInserter getInserter(String tablename) {
        return this.insertThreads.get(tablename);
    }

    private final void startInserters() {
        for (Map.Entry<String, DBInserter> entry : this.insertThreads.entrySet()) {
            DBInserter inserter = entry.getValue();
            inserter.start();
        }
    }

    private final void stopInsertersNormal() {
        for (Map.Entry<String, DBInserter> entry : this.insertThreads.entrySet()) {
            DBInserter thread = entry.getValue();
            thread.stopNormal();
        }
    }

    private final void stopInsertersForced() {
        for (Map.Entry<String, DBInserter> entry : this.insertThreads.entrySet()) {
            DBInserter thread = entry.getValue();
            thread.stopForced();
        }
    }

    private final void pushEOQ_toInserter() {
        for (Map.Entry<String, DBInserter> entry : this.insertThreads.entrySet()) {
            DBInserter thread = entry.getValue();
            thread.pushData(DBInserter.END_OF_QUEUE);
        }
    }

    @Override
    public final void run() {
        Thread curThread = Thread.currentThread();
        while (this.testThread(curThread)) {
            LogPackage pack = (LogPackage)this.pollData();
            if (pack == null || pack == LogPackage.END_OF_QUEUE) break;
            this.makeData(pack);
        }
        if (this.testThread(curThread)) {
            this.onThreadStop();
        }
        this.pushEOQ_toInserter();
    }

    protected abstract void makeData(LogPackage var1);

    protected void onThreadStop() {
    }

    public void saveData(Map<String, String> dataMap) {
    }

    public void openData(Map<String, String> dataMap) {
    }
}

