/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data;

import org.tizen.dynamicanalyzer.model.DATime;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;

public class WebProfileData
extends LogData {
    int pid = 0;
    int tid = 0;
    String functionName = null;
    int functionLineNumber = 0;
    String functionURL = null;
    long entrySeq = -1L;

    public WebProfileData() {
    }

    public WebProfileData(int id, long seq, int pid, int tid, int functionLineNumber, String functionName, String functionURL, long time) {
        this.msgID = id;
        this.seq = seq;
        this.pid = pid;
        this.tid = tid;
        this.functionLineNumber = functionLineNumber;
        this.functionName = functionName;
        this.functionURL = functionURL;
        this.time = time;
    }

    @Override
    public WebProfileData clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    protected boolean parse(DATime startTime) {
        super.parse(startTime);
        switch (this.msgID) {
            case 21: {
                this.pid = this.getInt();
                this.tid = this.getInt();
                this.functionLineNumber = this.getInt();
                this.functionName = this.getString();
                this.functionURL = this.getString();
                break;
            }
            case 22: {
                this.pid = this.getInt();
                this.tid = this.getInt();
                this.functionName = this.getString();
                break;
            }
        }
        return true;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public int getFunctionLineNumber() {
        return this.functionLineNumber;
    }

    public void setFunctionLineNumber(int functionLineNumber) {
        this.functionLineNumber = functionLineNumber;
    }

    public String getFunctionURL() {
        return this.functionURL;
    }

    public void setFunctionURL(String functionURL) {
        this.functionURL = functionURL;
    }

    public long getEntrySeq() {
        return this.entrySeq;
    }

    public void setEntrySeq(long entrySeq) {
        this.entrySeq = entrySeq;
    }

    public String generateFunctionKey() {
        return String.valueOf(this.functionURL) + this.functionLineNumber + this.functionName;
    }
}

