/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import com.google.protobuf.GeneratedMessage;
import org.json.simple.JSONObject;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ILsn;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ListenMap;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ListenSet;

public class EventMgr {
    private ListenMap<ListenSet<ILsn>> m_lsns = new ListenMap();
    private static EventMgr _inst;

    public static EventMgr getInstance() {
        if (_inst == null) {
            _inst = new EventMgr();
        }
        return _inst;
    }

    public void AddLsnSet(String name) {
        if (this.m_lsns.Find(name) != null) {
            return;
        }
        ListenSet lsn = new ListenSet();
        this.m_lsns.add(name, lsn);
    }

    public void RemoveLsnSet(String name) {
        this.m_lsns.remove(name);
    }

    public void AddLsn(String name, ILsn lsn) {
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        set.add(lsn);
    }

    public void RemoveLsn(String name, ILsn lsn) {
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        set.remove(lsn);
    }

    public void Invoke(String name, JSONObject param) {
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        int i = 0;
        while (i < set.size()) {
            ILsn lsn = set.get(i);
            if (lsn != null) {
                lsn.OnEventProc(name, param);
            }
            ++i;
        }
    }

    public void InvokePB(String name, GeneratedMessage param) {
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        int i = 0;
        while (i < set.size()) {
            ILsn lsn = set.get(i);
            if (lsn != null) {
                lsn.OnEventProcPB(name, param);
            }
            ++i;
        }
    }
}

