/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTableIndex;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.chart.IntervalManager;

public class PersistentAllocationsSelectionListener
extends SelectionAdapter {
    List<GridItem> itemlistSortedByTime;

    public void widgetSelected(SelectionEvent e) {
        if (!(e.widget instanceof Grid)) {
            return;
        }
        Grid table = (Grid)e.widget;
        IntervalManager.INSTANCE.removeIntervals();
        this.itemlistSortedByTime = Arrays.asList(table.getItems());
        Collections.sort(this.itemlistSortedByTime, (o1, o2) -> {
            Long seq1 = (Long)((DATableDataFormat)o1.getData()).getData().get(MemoryPersistentAllocationsTableIndex.SEQ.getIndex());
            Long seq2 = (Long)((DATableDataFormat)o2.getData()).getData().get(MemoryPersistentAllocationsTableIndex.SEQ.getIndex());
            return Long.compare(seq1, seq2);
        });
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<GridItem> items = new ArrayList<GridItem>();
        items.addAll(Arrays.asList(table.getSelection()));
        if (items.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.itemlistSortedByTime.size()) {
            GridItem item = this.itemlistSortedByTime.get(i);
            if (items.contains(item)) {
                indexes.add(i);
                items.remove(item);
                if (items.isEmpty()) {
                    break;
                }
            } else {
                if (!indexes.isEmpty()) {
                    this.addSelectionMarker((Integer)indexes.get(0), (Integer)indexes.get(indexes.size() - 1));
                }
                indexes.clear();
            }
            ++i;
        }
        if (!indexes.isEmpty()) {
            this.addSelectionMarker((Integer)indexes.get(0), (Integer)indexes.get(indexes.size() - 1));
        }
        IntervalManager.INSTANCE.notifyListeners();
    }

    private void addSelectionMarker(int startIndex, int endIndex) {
        Long startTime = (Long)((DATableDataFormat)this.itemlistSortedByTime.get(startIndex).getData()).getData().get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
        double start = (double)startTime.longValue() / 1000000.0;
        Long endTime = (Long)((DATableDataFormat)this.itemlistSortedByTime.get(endIndex).getData()).getData().get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
        double end = (double)endTime.longValue() / 1000000.0;
        IntervalManager.INSTANCE.addInterval(start, end);
    }
}

