/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class SyncDataDBTable
extends DBTable {
    public static final String TABLENAME = "SYNC_DATA";
    public static final String QUERY_OPTION = "order by " + COLUMN.SYNC_DATA_ID.name;
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.SYNC_DATA_ID.name) + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.SYNC_TYPE.name + "," + COLUMN.SYNC_VALUE.name + "," + COLUMN.ATTRIBUTE_TYPE.name + "," + COLUMN.SYNC_DATA_TYPE.name + "," + COLUMN.PARENT_ID.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "SYNC_DATA" + "  order by " + COLUMN.SYNC_DATA_ID.name;

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public SyncDataDBTable() {
        this.addColumn(new DBColumn(COLUMN.SYNC_DATA_ID.name, "PRIMARY KEY", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.SYNC_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.SYNC_VALUE.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.ATTRIBUTE_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.SYNC_DATA_TYPE.name, "NOT NULL", "TINYINT"));
        this.addColumn(new DBColumn(COLUMN.PARENT_ID.name, "", "INTEGER"));
    }

    public List<List<Object>> getSyncDataFromDB() {
        return this.selectAllColumnData(QUERY_OPTION);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setInt(COLUMN.SYNC_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.SYNC_DATA_ID.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                prep.setByte(COLUMN.SYNC_TYPE.index + 1, (Byte)rowData.get(COLUMN.SYNC_TYPE.index));
                prep.setLong(COLUMN.SYNC_VALUE.index + 1, (Long)rowData.get(COLUMN.SYNC_VALUE.index));
                prep.setByte(COLUMN.ATTRIBUTE_TYPE.index + 1, (Byte)rowData.get(COLUMN.ATTRIBUTE_TYPE.index));
                prep.setByte(COLUMN.SYNC_DATA_TYPE.index + 1, (Byte)rowData.get(COLUMN.SYNC_DATA_TYPE.index));
                prep.setInt(COLUMN.PARENT_ID.index + 1, (Integer)rowData.get(COLUMN.PARENT_ID.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getInt(COLUMN.SYNC_DATA_ID.index + 1));
            row.add(rs.getInt(COLUMN.PID.index + 1));
            row.add(rs.getInt(COLUMN.TID.index + 1));
            row.add(rs.getByte(COLUMN.SYNC_TYPE.index + 1));
            row.add(rs.getLong(COLUMN.SYNC_VALUE.index + 1));
            row.add(rs.getByte(COLUMN.ATTRIBUTE_TYPE.index + 1));
            row.add(rs.getByte(COLUMN.SYNC_DATA_TYPE.index + 1));
            row.add(rs.getInt(COLUMN.PARENT_ID.index + 1));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SYNC_DATA_ID(0, "SYNC_DATA_ID"),
        PID(1, "PID"),
        TID(2, "TID"),
        SYNC_TYPE(3, "SYNC_TYPE"),
        SYNC_VALUE(4, "SYNC_VALUE"),
        ATTRIBUTE_TYPE(5, "ATTRIBUTE_TYPE"),
        SYNC_DATA_TYPE(6, "SYNC_DATA_TYPE"),
        PARENT_ID(7, "PARENT_ID");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

