/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadAPIDBTable
extends DBTable {
    public static final String TABLENAME = "THREAD_API";
    private static final String SELECT_COLUMN = String.valueOf(COLUMN.SEQUENCE_NUMBER.name) + "," + COLUMN.CALL_TIME.name + "," + COLUMN.API_ID.name + "," + COLUMN.PID.name + "," + COLUMN.TID.name + "," + COLUMN.ARGUMENT.name + "," + COLUMN.RETURN_VALUE.name + "," + COLUMN.ERROR_NUMBER.name;
    public static final String SELECT_QUERY = "select " + SELECT_COLUMN + " from " + "THREAD_API" + "  where " + COLUMN.THREAD_DATA_ID.name + " = %s";

    @Override
    public String getTableName() {
        return TABLENAME;
    }

    public ThreadAPIDBTable() {
        this.addColumn(new DBColumn(COLUMN.SEQUENCE_NUMBER.name, "PRIMARY KEY", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.THREAD_DATA_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.CALL_TIME.name, "NOT NULL", "BIGINT"));
        this.addColumn(new DBColumn(COLUMN.API_ID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.PID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.TID.name, "NOT NULL", "INTEGER"));
        this.addColumn(new DBColumn(COLUMN.ARGUMENT.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.RETURN_VALUE.name, "", "VARCHAR", 1024));
        this.addColumn(new DBColumn(COLUMN.ERROR_NUMBER.name, "", "BIGINT"));
        this.addIndex(COLUMN.THREAD_DATA_ID.index);
    }

    public List<List<Object>> getThreadAPIFromDB() {
        return this.selectAllColumnData(null);
    }

    @Override
    public boolean prepare(PreparedStatement prep, List<Object> rowData) {
        boolean isPrepared = true;
        int columnsize = this.getColumnSize();
        if (columnsize != rowData.size()) {
            isPrepared = false;
        } else {
            try {
                prep.setLong(COLUMN.SEQUENCE_NUMBER.index + 1, (Long)rowData.get(COLUMN.SEQUENCE_NUMBER.index));
                prep.setInt(COLUMN.THREAD_DATA_ID.index + 1, (Integer)rowData.get(COLUMN.THREAD_DATA_ID.index));
                prep.setLong(COLUMN.CALL_TIME.index + 1, (Long)rowData.get(COLUMN.CALL_TIME.index));
                prep.setInt(COLUMN.API_ID.index + 1, (Integer)rowData.get(COLUMN.API_ID.index));
                prep.setInt(COLUMN.PID.index + 1, (Integer)rowData.get(COLUMN.PID.index));
                prep.setInt(COLUMN.TID.index + 1, (Integer)rowData.get(COLUMN.TID.index));
                String argumentStr = this.clipString((String)rowData.get(COLUMN.ARGUMENT.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.ARGUMENT.index + 1, argumentStr);
                String retStr = this.clipString((String)rowData.get(COLUMN.RETURN_VALUE.index), 1024, rowData.get(COLUMN.SEQUENCE_NUMBER.index).toString());
                prep.setString(COLUMN.RETURN_VALUE.index + 1, retStr);
                prep.setLong(COLUMN.ERROR_NUMBER.index + 1, (Long)rowData.get(COLUMN.ERROR_NUMBER.index));
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
                isPrepared = false;
            }
        }
        return isPrepared;
    }

    @Override
    public List<Object> extractDataFromResultSet(ResultSet rs) {
        ArrayList<Object> row = new ArrayList<Object>();
        try {
            row.add(rs.getLong(COLUMN.SEQUENCE_NUMBER.index + 1));
            row.add(rs.getInt(COLUMN.THREAD_DATA_ID.index + 1));
            row.add(rs.getLong(COLUMN.CALL_TIME.index + 1));
            row.add(rs.getInt(COLUMN.API_ID.index + 1));
            row.add(rs.getInt(COLUMN.PID.index + 1));
            row.add(rs.getInt(COLUMN.TID.index + 1));
            row.add(rs.getString(COLUMN.ARGUMENT.index + 1));
            row.add(rs.getString(COLUMN.RETURN_VALUE.index + 1));
            row.add(rs.getLong(COLUMN.ERROR_NUMBER.index + 1));
        }
        catch (SQLException e) {
            Logger.exception((Throwable)e);
            return null;
        }
        return row;
    }

    public static enum COLUMN {
        SEQUENCE_NUMBER(0, "SEQUENCE_NUMBER"),
        THREAD_DATA_ID(1, "THREAD_DATA_ID"),
        CALL_TIME(2, "CALL_TIME"),
        API_ID(3, "API_ID"),
        PID(4, "PID"),
        TID(5, "TID"),
        ARGUMENT(6, "ARGUMENT"),
        RETURN_VALUE(7, "RETURN_VALUE"),
        ERROR_NUMBER(8, "ERROR_NUMBER");

        public final int index;
        public final String name;

        private COLUMN(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

