/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.project.LibraryObject;
import org.tizen.dynamicanalyzer.project.ProcessInformation;
import org.tizen.dynamicanalyzer.project.ProcessMemoryMap;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.WebProfileData;
import org.tizen.dynamicanalyzer.ui.info.callstack.CallStackUnit;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfilingTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryIndexer;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.WebFunctionExitDBTable;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableRegistry;
import org.tizen.dynamicanalyzer.util.Logger;

public class CallTraceDataManager
extends PageDataManager {
    private static CallTraceDataManager instance = new CallTraceDataManager();
    private FunctionEntryDBTable functionEntryTable = new FunctionEntryDBTable();
    private WebFunctionEntryDBTable webFunctionEntryTable = new WebFunctionEntryDBTable();
    private WebFunctionExitDBTable webFunctionExitTable = new WebFunctionExitDBTable();

    private CallTraceDataManager() {
    }

    public FunctionEntryDBTable getFunctionEntryTable() {
        return this.functionEntryTable;
    }

    public WebFunctionEntryDBTable getWebFunctionEntryTable() {
        return this.webFunctionEntryTable;
    }

    public WebFunctionExitDBTable getWebFunctionExitTable() {
        return this.webFunctionExitTable;
    }

    public static CallTraceDataManager getInstance() {
        return instance;
    }

    public void clear() {
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.makeNativeData(pack);
        this.makeWebData(pack);
    }

    private void makeNativeData(LogPackage pack) {
        Logs exitLogs;
        Logs entryLogs = pack.getLogs(8);
        if (entryLogs != null && !entryLogs.getRawLogs().isEmpty()) {
            List<LogData> inputs = entryLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ProfileData pData = (ProfileData)inputs.get(i);
                if (pData.getProbeType() != 4) {
                    insertData.add(this.createEntryRowData(pData));
                    ProcessInformation process = Global.getProject().getProcessInformation(pData.getPid());
                    process.addFunctionEntryLogCount();
                }
                ++i;
            }
            if (!insertData.isEmpty()) {
                this.functionEntryTable.insertData(insertData);
            }
        }
        if ((exitLogs = pack.getLogs(9)) != null && !exitLogs.getRawLogs().isEmpty()) {
            List<LogData> inputs = exitLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ProfileData pData = (ProfileData)inputs.get(i);
                insertData.add(this.createExitRowData(pData));
                ++i;
            }
            if (!insertData.isEmpty()) {
                this.functionEntryTable.insertData(insertData);
            }
        }
    }

    private List<Object> createEntryRowData(ProfileData pData) {
        ArrayList<Object> insertRowData = new ArrayList<Object>();
        insertRowData.add(Boolean.TRUE);
        insertRowData.add(pData.getSeq());
        insertRowData.add(pData.getPid());
        insertRowData.add(pData.getTid());
        if (pData.getApiId() >= 0) {
            insertRowData.add(pData.getApiId());
        } else {
            insertRowData.add(0);
        }
        insertRowData.add(pData.getBinaryId());
        insertRowData.add(pData.getTime());
        insertRowData.add(0L);
        insertRowData.add(pData.getCallerPcAddr());
        insertRowData.add(pData.getPcAddr());
        insertRowData.add(pData.getArgs());
        insertRowData.add("");
        return insertRowData;
    }

    private List<Object> createExitRowData(ProfileData pData) {
        ArrayList<Object> insertRowData = new ArrayList<Object>();
        insertRowData.add(Boolean.FALSE);
        insertRowData.add(pData.getSeq());
        insertRowData.add(pData.getPid());
        insertRowData.add(pData.getTid());
        insertRowData.add(0);
        insertRowData.add(0);
        insertRowData.add(pData.getTime());
        insertRowData.add(pData.getTime());
        insertRowData.add(pData.getCallerPcAddr());
        insertRowData.add(pData.getPcAddr());
        insertRowData.add("");
        insertRowData.add(pData.getReturn());
        return insertRowData;
    }

    private void makeWebData(LogPackage pack) {
        Logs exitLogs;
        Logs entryLogs = pack.getLogs(21);
        if (entryLogs != null && !entryLogs.getRawLogs().isEmpty()) {
            List<LogData> inputs = entryLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ArrayList<Object> insertRowData = new ArrayList<Object>();
                WebProfileData pData = (WebProfileData)inputs.get(i);
                insertRowData.add(pData.getSeq());
                insertRowData.add(pData.getPid());
                insertRowData.add(pData.getTid());
                insertRowData.add(pData.getFunctionLineNumber());
                insertRowData.add(pData.getFunctionName());
                insertRowData.add(pData.getFunctionURL());
                insertRowData.add(pData.getTime());
                insertData.add(insertRowData);
                ProcessInformation process = Global.getProject().getProcessInformation(pData.getPid());
                process.addFunctionEntryLogCount();
                ++i;
            }
            if (!insertData.isEmpty()) {
                this.webFunctionEntryTable.insertData(insertData);
            }
        }
        if ((exitLogs = pack.getLogs(22)) != null && !exitLogs.getRawLogs().isEmpty()) {
            List<LogData> inputs = exitLogs.getLogs();
            ArrayList<List<Object>> insertData = new ArrayList<List<Object>>();
            int size = inputs.size();
            int i = 0;
            while (i < size) {
                ArrayList<Long> insertRowData = new ArrayList<Long>();
                WebProfileData pData = (WebProfileData)inputs.get(i);
                insertRowData.add(pData.getEntrySeq());
                insertRowData.add(pData.getSeq());
                insertRowData.add(pData.getTime());
                insertData.add(insertRowData);
                ++i;
            }
            if (!insertData.isEmpty()) {
                this.webFunctionExitTable.insertData(insertData);
            }
        }
    }

    public void addCallStackIndexes() {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int[] nArray = Global.getProject().getProcessIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int pid = nArray[n2];
            try {
                Connection conn = SqlConnectionManager.getUpdateConnection();
                conn.setAutoCommit(true);
                Statement statement = conn.createStatement();
                Thread t = new Thread((Runnable)new FunctionEntryIndexer(this.functionEntryTable, pid, statement), "Function Entry Indexer " + pid);
                t.setUncaughtExceptionHandler((thread, exception) -> {
                    Logger.error((Object)exception);
                    UIActionHolder.getUIAction().showWarning("The exception occurred when processing function profiling data. The Call Trace and Function Profiling information may be incorrect after this.");
                    try {
                        SqlConnectionManager.putUpdateConnection(statement.getConnection());
                    }
                    catch (SQLException e) {
                        Logger.error((Object)("Failed to close database connection: " + e));
                    }
                });
                threads.add(t);
                t.start();
            }
            catch (SQLException e) {
                Logger.error((Object)("failed to connect to database: " + e));
            }
            ++n2;
        }
        threads.forEach(arg0 -> {
            try {
                arg0.join();
            }
            catch (InterruptedException e) {
                Logger.error((Object)e);
                Thread.currentThread().interrupt();
            }
        });
        DATableComposite profiling = DATableRegistry.getTable(ProfilingTable.class.getName());
        if (profiling != null) {
            Display.getDefault().syncExec(profiling::updateTable);
        }
        FunctionUsageProfiler.getInstance().doSaveProfilingData();
    }

    public List<CallStackUnit> getCallstackForSampling(Integer pid, Integer tid, Long time) {
        return this.getCallStack(pid, tid, time, true);
    }

    public List<CallStackUnit> getCallstackForTable(Integer pid, Integer tid, Long time) {
        return this.getCallStack(pid, tid, time, false);
    }

    private List<CallStackUnit> getCallStack(Integer pid, Integer tid, Long time, boolean calledforExit) {
        String where = " where " + FunctionEntryDBTable.COLUMN.START_TIME.name + "<=" + time + " and " + "(" + FunctionEntryDBTable.COLUMN.END_TIME.name + (calledforExit ? ">=" : Character.valueOf('>')) + time + " or " + FunctionEntryDBTable.COLUMN.END_TIME.name + "=0" + ')' + " and " + FunctionEntryDBTable.COLUMN.IS_ENTRY.name + " and " + FunctionEntryDBTable.COLUMN.PID.name + '=' + pid + " and " + FunctionEntryDBTable.COLUMN.TID.name + '=' + tid + " order by " + FunctionEntryDBTable.COLUMN.START_TIME.name + " DESC ";
        List<List<Object>> list = this.functionEntryTable.selectAllColumnData(where);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CallStackUnit> res = new ArrayList<CallStackUnit>();
        ProcessMemoryMap memMap = Global.getProject().getProcessInformation(pid).getProcessMemoryMap(time);
        CallStackUnit unknown = new CallStackUnit();
        int i = 0;
        while (i < list.size()) {
            List<Object> buf = list.get(i);
            long address = (Long)buf.get(FunctionEntryDBTable.COLUMN.START_PC_ADDRESS.index);
            long callerAddress = (Long)buf.get(FunctionEntryDBTable.COLUMN.CALLER_PC_ADDRESS.index);
            int dbpid = (Integer)buf.get(FunctionEntryDBTable.COLUMN.PID.index);
            int dbtid = (Integer)buf.get(FunctionEntryDBTable.COLUMN.TID.index);
            long dbtime = (Long)buf.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
            int functionID = (Integer)buf.get(FunctionEntryDBTable.COLUMN.FUNCTION_ID.index);
            int binaryID = (Integer)buf.get(FunctionEntryDBTable.COLUMN.BINARY_ID.index);
            String functionName = Global.getFunctionName(functionID);
            String path = Global.getLibraryName(binaryID);
            CallStackUnit api = new CallStackUnit(address, callerAddress, dbpid, dbtid, dbtime, functionID, binaryID, functionName, path);
            res.add(api);
            if (i < list.size() - 1 && this.calledFromUnknown(callerAddress, memMap, list.get(i + 1))) {
                res.add(unknown);
            }
            ++i;
        }
        return res;
    }

    private boolean calledFromUnknown(long callerAddress, ProcessMemoryMap memMap, List<Object> list) {
        LibraryObject lib = memMap.getLibraryByAddress(callerAddress);
        if (lib == null) {
            return true;
        }
        return lib.getBinaryID() != ((Integer)list.get(FunctionEntryDBTable.COLUMN.BINARY_ID.index)).intValue();
    }

    public List<List<Object>> getCallTrace() {
        String where = " where " + FunctionEntryDBTable.COLUMN.IS_ENTRY.name + " and " + (Object)((Object)FunctionEntryDBTable.COLUMN.FUNCTION_ID) + ">" + 0 + " order by " + FunctionEntryDBTable.COLUMN.START_TIME.name;
        return this.functionEntryTable.selectAllColumnData(where);
    }

    public CallStackUnit getLastEntry(Integer pid, Integer tid, Long time) {
        String where = " where " + FunctionEntryDBTable.COLUMN.START_TIME.name + "<=" + time + " and " + FunctionEntryDBTable.COLUMN.IS_ENTRY.name + " and " + FunctionEntryDBTable.COLUMN.PID.name + "=" + pid + " and " + FunctionEntryDBTable.COLUMN.TID.name + "=" + tid + " order by " + FunctionEntryDBTable.COLUMN.START_TIME.name + " DESC " + " limit 1";
        List<List<Object>> list = this.functionEntryTable.selectAllColumnData(where);
        if (list == null || list.isEmpty()) {
            return null;
        }
        long address = (Long)list.get(0).get(FunctionEntryDBTable.COLUMN.START_PC_ADDRESS.index);
        long callerAddress = (Long)list.get(0).get(FunctionEntryDBTable.COLUMN.CALLER_PC_ADDRESS.index);
        int dbpid = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.PID.index);
        int dbtid = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.TID.index);
        long dbtime = (Long)list.get(0).get(FunctionEntryDBTable.COLUMN.START_TIME.index);
        int functionID = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.FUNCTION_ID.index);
        int binaryID = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.BINARY_ID.index);
        String functionName = Global.getFunctionName(functionID);
        String path = Global.getLibraryName(binaryID);
        return new CallStackUnit(address, callerAddress, dbpid, dbtid, dbtime, functionID, binaryID, functionName, path);
    }

    public CallStackUnit getLastEntryInFunction(int pid, int tid, long time, int functionID) {
        String where = " where " + FunctionEntryDBTable.COLUMN.START_TIME.name + "<=" + time + " and " + FunctionEntryDBTable.COLUMN.IS_ENTRY.name + " and " + FunctionEntryDBTable.COLUMN.PID.name + "=" + pid + " and " + FunctionEntryDBTable.COLUMN.TID.name + "=" + tid + " and " + FunctionEntryDBTable.COLUMN.FUNCTION_ID.name + "=" + functionID + " order by " + FunctionEntryDBTable.COLUMN.START_TIME.name + " DESC " + " limit 1";
        List<List<Object>> list = this.functionEntryTable.selectAllColumnData(where);
        if (list == null || list.isEmpty()) {
            return null;
        }
        long address = (Long)list.get(0).get(FunctionEntryDBTable.COLUMN.START_PC_ADDRESS.index);
        long callerAddress = (Long)list.get(0).get(FunctionEntryDBTable.COLUMN.CALLER_PC_ADDRESS.index);
        int epid = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.PID.index);
        int etid = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.TID.index);
        long etime = (Long)list.get(0).get(FunctionEntryDBTable.COLUMN.START_TIME.index);
        int efunctionID = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.FUNCTION_ID.index);
        int binaryID = (Integer)list.get(0).get(FunctionEntryDBTable.COLUMN.BINARY_ID.index);
        String functionName = Global.getFunctionName(functionID);
        String path = Global.getLibraryName(binaryID);
        return new CallStackUnit(address, callerAddress, epid, etid, etime, efunctionID, binaryID, functionName, path);
    }
}

