/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionProfilingDataUpdater;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class FunctionEntryIndexer
implements Runnable {
    FunctionEntryDBTable dbTable;
    HashMap<Integer, Deque<Long>> callstackByTid = new HashMap();
    final int pid;
    Statement statement;
    static final long TIMESTEP = 200000L;

    public FunctionEntryIndexer(FunctionEntryDBTable dbTable, int pid, Statement statement) {
        this.dbTable = dbTable;
        this.pid = pid;
        this.statement = statement;
    }

    @Override
    public void run() {
        ProgressHolder progress = null;
        if (Global.isGUIMode()) {
            progress = ProgressManager.INSTANCE.createProgress(true, 1, "Indexing functions for " + this.pid, AnalyzerLabels.DLG_PLEASE_WAIT, null);
        }
        Logger.debug((Object)"Indexing begins");
        long totalTime = Global.getProject().getTotalStopTime();
        FunctionProfilingDataUpdater functionProfilingDataUpdater = new FunctionProfilingDataUpdater(this.dbTable, this.pid);
        long time = 0L;
        while (time < totalTime) {
            this.updateFunctionEntryTable(time);
            functionProfilingDataUpdater.updateProfilingInfo(time);
            time += 200000L;
            if (progress == null) continue;
            progress.setValue((int)(100.0 * (double)time / (double)totalTime));
        }
        ProgressManager.INSTANCE.stopProgress(progress);
        functionProfilingDataUpdater.updateRates(totalTime);
        try {
            SqlConnectionManager.putUpdateConnection(this.statement.getConnection());
        }
        catch (SQLException e) {
            Logger.error((Object)("Failed to close database connection: " + e));
        }
        Logger.debug((Object)"Indexing finished");
    }

    private void putEntryToMap(List<Object> list) {
        int tid = (Integer)list.get(FunctionEntryDBTable.COLUMN.TID.index);
        Deque<Long> callstack = this.callstackByTid.get(tid);
        if (callstack == null) {
            callstack = new ArrayDeque<Long>();
            this.callstackByTid.put(tid, callstack);
        }
        callstack.push((Long)list.get(FunctionEntryDBTable.COLUMN.START_TIME.index));
    }

    private String updateEntryWithCorrespondingExitTimeAndRemoveFromMap(List<Object> list) throws ExitWithoutEntryException {
        int tid = (Integer)list.get(FunctionEntryDBTable.COLUMN.TID.index);
        Deque<Long> callstack = this.callstackByTid.get(tid);
        if (callstack == null || callstack.isEmpty()) {
            throw new ExitWithoutEntryException("exit without entry " + list.get(FunctionEntryDBTable.COLUMN.END_TIME.index));
        }
        Long entryTime = callstack.pop();
        return " update " + this.dbTable.getTableName() + " set " + FunctionEntryDBTable.COLUMN.END_TIME.name + " = " + list.get(FunctionEntryDBTable.COLUMN.END_TIME.index) + " where " + FunctionEntryDBTable.COLUMN.START_TIME.name + " = " + entryTime + " and " + FunctionEntryDBTable.COLUMN.TID.name + "=" + tid;
    }

    private void updateFunctionEntryTable(long time) {
        String where = " where " + FunctionEntryDBTable.COLUMN.START_TIME.name + ">" + time + " and " + FunctionEntryDBTable.COLUMN.START_TIME.name + "<=" + (time + 200000L) + " order by " + FunctionEntryDBTable.COLUMN.START_TIME.name;
        for (List<Object> list : this.dbTable.selectAllColumnData(where)) {
            if (((Boolean)list.get(FunctionEntryDBTable.COLUMN.IS_ENTRY.index)).booleanValue()) {
                this.putEntryToMap(list);
                continue;
            }
            try {
                this.statement.addBatch(this.updateEntryWithCorrespondingExitTimeAndRemoveFromMap(list));
            }
            catch (SQLException | ExitWithoutEntryException e) {
                Logger.error((Object)("Failed to add update query:" + e));
            }
        }
        try {
            this.statement.executeBatch();
            this.statement.clearBatch();
        }
        catch (SQLException e) {
            Logger.error((Object)("Failed to connect to database or to perform update: " + e));
        }
    }

    static final class ExitWithoutEntryException
    extends Exception {
        private static final long serialVersionUID = -8929551670368096651L;

        public ExitWithoutEntryException(String string) {
            super(string);
        }
    }
}

