/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.common;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.common.TimelineEditItemsDialog;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;

public class AddChartMenuComposite
extends Composite {
    private DACustomButton addItems;
    private DACustomButtonClickEventListener addItemListButtonListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
            TimelineEditItemsDialog dialog = new TimelineEditItemsDialog(shell);
            if (!dialog.isRunningDialog()) {
                dialog.open();
            }
        }
    };

    public AddChartMenuComposite(Composite parent) {
        super(parent, 0);
    }

    public void setAddItemListButtonListener(DACustomButtonClickEventListener addItemListButtonListener) {
        this.addItemListButtonListener = addItemListButtonListener;
    }

    public void createAddMenuComp() {
        this.setBackground(ColorResources.VIEW_BG_COLOR);
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        this.setLayout((Layout)gLayout);
        this.createAddButton();
    }

    private void createAddButton() {
        Composite addItemComp = new Composite((Composite)this, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        gLayout.horizontalSpacing = 0;
        gLayout.verticalSpacing = 0;
        addItemComp.setLayout((Layout)gLayout);
        addItemComp.setBackground(ColorResources.VIEW_BG_COLOR);
        this.addItems = new DACustomButton(addItemComp, ColorResources.ADD_CHART_NORMAL_START, ColorResources.ADD_CHART_NORMAL_END, ColorResources.ADD_CHART_PUSH_START, ColorResources.ADD_CHART_PUSH_END, ColorResources.ADD_CHART_HOVER_START, ColorResources.ADD_CHART_HOVER_END, ColorResources.ADD_CHART_DISABLE_COLOR, ColorResources.ADD_CHART_DISABLE_COLOR);
        this.addItems.setOutlineColors(ColorResources.ADD_CHART_NORMAL_STROKE, ColorResources.ADD_CHART_PUSH_STROKE, ColorResources.ADD_CHART_HOVER_STROKE, null);
        this.addItems.setTitle(TimelineChartLabels.TIMELINE_TICK_ADD);
        this.addItems.setButtonImages(ImageResources.ADD_CHART_ICON, ImageResources.ADD_CHART_ICON, ImageResources.ADD_CHART_ICON, ImageResources.ADD_CHART_ICON);
        this.addItems.setButtonImagePoint(new Point(6, 4));
        this.addItems.setFontPoint(new Point(47, 5));
        this.addItems.setFontColors(ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR, ColorResources.ADD_CHART_FONT_COLOR);
        this.addItems.setButtonFont(FontResources.ADDITEM_BUTTON_FONT);
        GridData gDataAddBtn = new GridData();
        gDataAddBtn.horizontalAlignment = 4;
        gDataAddBtn.grabExcessHorizontalSpace = true;
        gDataAddBtn.verticalAlignment = 4;
        gDataAddBtn.grabExcessVerticalSpace = true;
        this.addItems.setLayoutData((Object)gDataAddBtn);
        this.addItems.addClickListener(this.addItemListButtonListener);
        GridData gDataInfo = new GridData();
        gDataInfo.widthHint = 118;
        gDataInfo.verticalAlignment = 4;
        gDataInfo.grabExcessVerticalSpace = true;
        addItemComp.setLayoutData((Object)gDataInfo);
    }
}

