/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.CompoundInstruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IAggregate;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.internal.symbols.IEnumeration;
import org.eclipse.cdt.debug.edc.internal.symbols.IField;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.internal.symbols.ISubroutineType;
import org.eclipse.cdt.debug.edc.symbols.IMemoryVariableLocation;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.cdt.debug.edc.symbols.VariableLocationFactory;
import org.eclipse.core.runtime.CoreException;

public class OperatorIndirection
extends CompoundInstruction {
    public OperatorIndirection(int start) {
        super(start);
    }

    @Override
    public void execute() throws CoreException {
        OperandValue operand = this.popValue();
        IType opType = TypeUtils.getUnRefStrippedType(operand.getValueType());
        if (operand.getStringValue() != null) {
            this.pushNewValue(opType.getType(), (int)operand.getStringValue().charAt(0));
            return;
        }
        if (!TypeUtils.isPointerType(opType)) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorIndirection_RequiresPointer);
        }
        IPointerType pointer = (IPointerType)opType;
        IType pointedTo = pointer.getType();
        IType unqualifiedPointedTo = TypeUtils.getStrippedType(pointedTo);
        if (unqualifiedPointedTo instanceof IField && ((IField)unqualifiedPointedTo).getBitSize() != 0) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorIndirection_NoBitField);
        }
        OperandValue opValue = new OperandValue(unqualifiedPointedTo);
        IMemoryVariableLocation location = VariableLocationFactory.createMemoryVariableLocation(this.fInterpreter.getServicesTracker(), this.fInterpreter.getContext(), operand.getValue());
        if (unqualifiedPointedTo instanceof ICPPBasicType || unqualifiedPointedTo instanceof IPointerType || unqualifiedPointedTo instanceof IEnumeration) {
            int byteSize = unqualifiedPointedTo.getByteSize();
            if (unqualifiedPointedTo instanceof ICPPBasicType && byteSize == 0) {
                byteSize = 4;
            }
            if (byteSize != 1 && byteSize != 2 && byteSize != 4 && byteSize != 8) {
                throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.UnhandledSize, byteSize));
            }
            Number newValue = operand.getValueByType(unqualifiedPointedTo, location);
            opValue.setValue(newValue);
            opValue.setValueLocation(location);
            this.push(opValue);
        } else if (unqualifiedPointedTo instanceof IAggregate) {
            opValue.setAddressValue(location);
            opValue.setValueLocation(location);
            this.push(opValue);
        } else {
            if (unqualifiedPointedTo instanceof ISubroutineType) {
                throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorIndirection_NoFunction);
            }
            throw EDCDebugger.newCoreException(MessageFormat.format(ASTEvalMessages.OperatorIndirection_UnhandledType, unqualifiedPointedTo != null ? unqualifiedPointedTo.getName() : "null"));
        }
    }
}

