/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.debug.DebugTrace;

public class EDCTrace {
    public static final String DEBUG_TRACE = "/debug";
    public static final String RUN_CONTROL_TRACE = "/debug/runControl";
    public static final String STACK_TRACE = "/debug/stack";
    public static final String EXPRESSION_PARSE_TRACE = "/debug/expressionParse";
    public static final String SYMBOL_READER_TRACE = "/debug/symbolReader";
    public static final String SYMBOL_READER_VERBOSE_TRACE = "/debug/symbolReader/verbose";
    public static final String VARIABLE_VALUE_TRACE = "/debug/variableValue";
    public static final String BREAKPOINTS_TRACE = "/debug/breakpoints";
    public static final String MEMORY_TRACE = "/debug/memory";
    public static final String ACPM_TRACE = "/debug/acpm";
    public static final String PERSISTENT_CACHE_TRACE = "/debug/persistentCache";
    public static boolean DEBUG_TRACE_ON;
    public static boolean RUN_CONTROL_TRACE_ON;
    public static boolean STACK_TRACE_ON;
    public static boolean EXPRESSION_PARSE_TRACE_ON;
    public static boolean SYMBOL_READER_TRACE_ON;
    public static boolean SYMBOL_READER_VERBOSE_TRACE_ON;
    public static boolean VARIABLE_VALUE_TRACE_ON;
    public static boolean BREAKPOINTS_TRACE_ON;
    public static boolean MEMORY_TRACE_ON;
    public static boolean ACPM_TRACE_ON;
    public static boolean PERSISTENT_CACHE_TRACE_ON;
    private static DebugTrace sTrace;

    private static boolean isOn(String option) {
        return "true".equals(Platform.getDebugOption((String)("org.eclipse.cdt.debug.edc" + option)));
    }

    public static void init() {
        if ("true".equals(Platform.getDebugOption((String)"org.eclipse.cdt.debug.edc/debug"))) {
            DEBUG_TRACE_ON = true;
            RUN_CONTROL_TRACE_ON = EDCTrace.isOn(RUN_CONTROL_TRACE);
            STACK_TRACE_ON = EDCTrace.isOn(STACK_TRACE);
            EXPRESSION_PARSE_TRACE_ON = EDCTrace.isOn(EXPRESSION_PARSE_TRACE);
            SYMBOL_READER_TRACE_ON = EDCTrace.isOn(SYMBOL_READER_TRACE);
            SYMBOL_READER_VERBOSE_TRACE_ON = SYMBOL_READER_TRACE_ON && EDCTrace.isOn(SYMBOL_READER_VERBOSE_TRACE);
            VARIABLE_VALUE_TRACE_ON = EDCTrace.isOn(VARIABLE_VALUE_TRACE);
            BREAKPOINTS_TRACE_ON = EDCTrace.isOn(BREAKPOINTS_TRACE);
            MEMORY_TRACE_ON = EDCTrace.isOn(MEMORY_TRACE);
            ACPM_TRACE_ON = EDCTrace.isOn(ACPM_TRACE);
            PERSISTENT_CACHE_TRACE_ON = EDCTrace.isOn(PERSISTENT_CACHE_TRACE);
        }
    }

    public static String fixArg(Object argument) {
        if (argument == null || sTrace instanceof NullDebugTrace) {
            return null;
        }
        return argument.toString().replaceAll("\\{", "[").replaceAll("\\}", "]");
    }

    public static String[] fixArgs(Object[] arguments) {
        if (arguments == null || sTrace instanceof NullDebugTrace) {
            return null;
        }
        String[] args = new String[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            args[i] = EDCTrace.fixArg(arguments[i]);
            ++i;
        }
        return args;
    }

    public static DebugTrace getTrace() {
        if (sTrace == null) {
            EDCDebugger activator = EDCDebugger.getDefault();
            sTrace = activator != null ? activator.getTrace() : new NullDebugTrace();
        }
        return sTrace;
    }

    static class NullDebugTrace
    implements DebugTrace {
        NullDebugTrace() {
        }

        public void trace(String option, String message) {
        }

        public void trace(String option, String message, Throwable error) {
        }

        public void traceDumpStack(String option) {
        }

        public void traceEntry(String option) {
        }

        public void traceEntry(String option, Object methodArgument) {
        }

        public void traceEntry(String option, Object[] methodArguments) {
        }

        public void traceExit(String option) {
        }

        public void traceExit(String option, Object result) {
        }
    }
}

