/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.symbols.ICPPBasicType;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class NumberFormatUtils {
    private static final String HEX_PREFIX = "0x";
    private static final String OCTAL_PREFIX = "0";
    private static final String BINARY_PREFIX = "0b";
    private static final String SINGLE_QUOTE = "'";
    private static final String DECIMAL_SUFFIX = " (Decimal)";

    public static String toHexString(Number number) {
        String str = null;
        if (number instanceof Integer) {
            str = Integer.toHexString((Integer)number);
        } else if (number instanceof Long) {
            str = Long.toHexString((Long)number);
        } else if (number instanceof BigInteger) {
            str = ((BigInteger)number).toString(16);
        } else if (number instanceof Float) {
            str = Float.toHexString(((Float)number).floatValue());
        } else if (number instanceof Double) {
            str = Double.toHexString((Double)number);
        }
        if (str != null && !str.startsWith(HEX_PREFIX)) {
            return HEX_PREFIX + str;
        }
        return str;
    }

    public static String toOctalString(Number number) {
        String str = null;
        if (number instanceof Integer) {
            str = Integer.toOctalString((Integer)number);
        } else if (number instanceof Long) {
            str = Long.toOctalString((Long)number);
        } else if (number instanceof BigInteger) {
            str = ((BigInteger)number).toString(8);
        }
        if (str != null && !str.startsWith(OCTAL_PREFIX)) {
            str = OCTAL_PREFIX + str;
        }
        if (str == null && (number instanceof Float || number instanceof Double)) {
            str = String.valueOf(number.toString()) + DECIMAL_SUFFIX;
        }
        return str;
    }

    public static String asBinary(Number number) {
        String str = null;
        if (number instanceof Integer) {
            str = Integer.toBinaryString((Integer)number);
        } else if (number instanceof Long) {
            str = Long.toBinaryString((Long)number);
        } else if (number instanceof BigInteger) {
            str = ((BigInteger)number).toString(2);
        }
        if (str != null && !str.startsWith(BINARY_PREFIX)) {
            str = BINARY_PREFIX + str;
        }
        if (str == null && (number instanceof Float || number instanceof Double)) {
            str = String.valueOf(number.toString()) + DECIMAL_SUFFIX;
        }
        return str;
    }

    public static String toCharString(Number number, IType valueType) {
        int intValue = number.intValue();
        String charVal = null;
        if (intValue < 128) {
            switch ((char)intValue) {
                case '\u0000': {
                    charVal = "\\0";
                    break;
                }
                case '\b': {
                    charVal = "\\b";
                    break;
                }
                case '\f': {
                    charVal = "\\f";
                    break;
                }
                case '\n': {
                    charVal = "\\n";
                    break;
                }
                case '\r': {
                    charVal = "\\r";
                    break;
                }
                case '\t': {
                    charVal = "\\t";
                    break;
                }
                case '\'': {
                    charVal = "\\'";
                    break;
                }
                case '\"': {
                    charVal = "\\\"";
                    break;
                }
                case '\\': {
                    charVal = "\\\\";
                    break;
                }
                case '\u000b': {
                    charVal = "\\v";
                }
            }
        }
        boolean isWchart = valueType instanceof ICPPBasicType && ((ICPPBasicType)valueType).getBaseType() == 7 || valueType.getName().equals("wchar_t");
        StringBuilder info = new StringBuilder();
        if (isWchart) {
            info.append(HEX_PREFIX);
            if (valueType.getByteSize() == 2) {
                info.append(String.format("%04X", intValue));
            } else {
                info.append(String.format("%08X", intValue));
            }
            info.append(" (L");
        } else {
            info.append("" + intValue);
            info.append(" (");
        }
        if (charVal == null) {
            String fmt = "\\U%08X";
            switch (valueType.getByteSize()) {
                case 1: {
                    fmt = "\\%03o";
                    intValue &= 0xFF;
                    break;
                }
                case 2: {
                    fmt = "\\u%04X";
                    intValue &= 0xFFFF;
                    break;
                }
                case 4: {
                    fmt = "\\U%08X";
                    intValue &= 0xFFFFFFFF;
                }
            }
            boolean gotRepr = false;
            try {
                if (!Character.isISOControl(intValue)) {
                    char[] chars = Character.toChars(intValue);
                    info.append(NumberFormatUtils.asStringQuoted(new String(chars)));
                    gotRepr = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (!gotRepr) {
                info.append(NumberFormatUtils.asStringQuoted(String.format(fmt, intValue)));
            }
        } else {
            info.append(NumberFormatUtils.asStringQuoted(charVal));
        }
        info.append(')');
        return info.toString();
    }

    public static String asStringQuoted(String val) {
        StringBuilder sb = new StringBuilder(SINGLE_QUOTE);
        sb.append(val);
        sb.append(SINGLE_QUOTE);
        return sb.toString();
    }

    public static BigInteger parseIntegerByFormat(String expressionValue, String formatId) {
        int radix = 10;
        if ("HEX.Format".equals(formatId)) {
            if (expressionValue.startsWith(HEX_PREFIX)) {
                expressionValue = expressionValue.substring(HEX_PREFIX.length());
            }
            radix = 16;
        } else if ("OCTAL.Format".equals(formatId)) {
            if (expressionValue.startsWith(OCTAL_PREFIX)) {
                expressionValue = expressionValue.substring(OCTAL_PREFIX.length());
            }
            radix = 8;
        } else if ("BINARY.Format".equals(formatId)) {
            if (expressionValue.startsWith(BINARY_PREFIX)) {
                expressionValue = expressionValue.substring(BINARY_PREFIX.length());
            }
            radix = 2;
        } else if ("NATURAL.Format".equals(formatId)) {
            if (expressionValue.startsWith(BINARY_PREFIX)) {
                expressionValue = expressionValue.substring(BINARY_PREFIX.length());
                radix = 2;
            } else if (expressionValue.startsWith(OCTAL_PREFIX)) {
                expressionValue = expressionValue.substring(OCTAL_PREFIX.length());
                radix = 8;
            } else if (expressionValue.startsWith(HEX_PREFIX)) {
                expressionValue = expressionValue.substring(HEX_PREFIX.length());
                radix = 16;
            }
        }
        try {
            return new BigInteger(expressionValue, radix);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

