/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.launch;

import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.INoop;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Snapshots;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Symbols;
import org.eclipse.cdt.debug.edc.services.ITargetEnvironment;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.BreakpointsMediator2;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ShutdownSequence
extends Sequence {
    String sessionId;
    String applicationName;
    String debugModelId;
    DsfServicesTracker tracker;
    private final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (!$assertionsDisabled && EDCDebugger.getDefault().getBundle().getBundleContext() == null) {
                throw new AssertionError();
            }
            ShutdownSequence.this.tracker = new DsfServicesTracker(EDCDebugger.getDefault().getBundle().getBundleContext(), ShutdownSequence.this.sessionId);
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ShutdownSequence.this.tracker.dispose();
            ShutdownSequence.this.tracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(Snapshots.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IDisassembly.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(BreakpointsMediator2.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IRegisters.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IBreakpoints.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ISourceLookup.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IExpressions.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IStack.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IModules.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IMemory.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IRunControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(IProcesses.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ITargetEnvironment.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(Symbols.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(INoop.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.tracker.dispose();
            ShutdownSequence.this.tracker = null;
            requestMonitor.done();
        }
    }};

    public ShutdownSequence(DsfExecutor executor, String sessionId, RequestMonitor requestMonitor) {
        super(executor, requestMonitor);
        this.sessionId = sessionId;
    }

    public Sequence.Step[] getSteps() {
        return this.steps;
    }

    private <V> void shutdownService(Class<V> clazz, final RequestMonitor requestMonitor) {
        IDsfService service = (IDsfService)this.tracker.getService(clazz);
        if (service != null) {
            service.shutdown(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

                protected void handleCompleted() {
                    this.isSuccess();
                    requestMonitor.done();
                }
            });
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "AbstractEDCService '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

