/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols;

import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.symbols.IForwardTypeReference;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IType;

public class Type
implements IType {
    public static final String TYPE_REFERENCE = "type_reference";
    protected String name;
    protected IScope scope;
    protected int byteSize;
    protected IType type;
    protected Map<Object, Object> properties;

    public Type(String name, IScope scope, int byteSize, Map<Object, Object> properties) {
        this.name = name;
        this.scope = scope;
        this.byteSize = byteSize;
        this.properties = properties;
    }

    @Override
    public void dispose() {
        this.properties = null;
        this.scope = null;
        this.type = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    @Override
    public int getByteSize() {
        return this.byteSize;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    @Override
    public IType getType() {
        if (this.type == null && this.properties != null) {
            this.type = (IType)this.properties.get(TYPE_REFERENCE);
        }
        if (this.type instanceof IForwardTypeReference) {
            this.type = ((IForwardTypeReference)this.type).getReferencedType();
        }
        return this.type;
    }

    @Override
    public void setType(IType type) {
        this.type = type;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    protected int updateByteSizeFromSubType() {
        IType theType;
        if (this.byteSize == 0 && (theType = this.getType()) != null) {
            this.byteSize = theType.getByteSize();
        }
        return this.byteSize;
    }
}

