/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.lifecycle.LifecycleData;

public class LifecycleBar
extends Canvas {
    public static final int HEIGHT = 7;
    private double visibleStartTime = 0.0;
    private double totalEndTime = 0.0;
    private int scale = 1;
    private ArrayList<LifecycleData> lifecycleDataList = new ArrayList();
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Rectangle rt = gc.getClipping();
            gc.setForeground(ColorResources.TIMELINE_TICK_COLOR);
            gc.drawLine(0, rt.height - 1, rt.width, rt.height - 1);
            List cloneList = (List)LifecycleBar.this.lifecycleDataList.clone();
            for (LifecycleData lifecycleData : cloneList) {
                double startTime = lifecycleData.getStartTime();
                int startPx = (int)LifecycleBar.this.secondToPixel(startTime);
                double endTime = lifecycleData.getEndTime();
                if (startPx >= LifecycleBar.this.getClientArea().width) break;
                if (endTime == -1.0) {
                    endTime = LifecycleBar.this.totalEndTime;
                }
                if (!(endTime > LifecycleBar.this.visibleStartTime)) continue;
                int endPx = (int)LifecycleBar.this.secondToPixel(endTime);
                gc.setBackground(lifecycleData.getColor());
                gc.fillRectangle(startPx + 1, 0, endPx - startPx + 1, 6);
            }
        }
    };

    public LifecycleBar(Composite parent) {
        super(parent, 0);
        this.addPaintListener(this.paintListener);
    }

    public void setVisibleStartTime(double visibleStartTime) {
        this.visibleStartTime = visibleStartTime;
    }

    public double getEndTime() {
        double endTime = 0.0;
        int dataSize = this.lifecycleDataList.size();
        if (dataSize > 0) {
            endTime = this.lifecycleDataList.get(dataSize - 1).getStartTime();
        }
        if (endTime < this.totalEndTime) {
            endTime = this.totalEndTime;
        }
        return endTime;
    }

    public void setTotalEndTime(double totalEndTime) {
        this.totalEndTime = totalEndTime;
        this.redraw();
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void addLifecycleData(LifecycleData lifecycleData) {
        int size = this.lifecycleDataList.size();
        if (size != 0) {
            LifecycleData lastData = this.lifecycleDataList.get(size - 1);
            lastData.setEndTime(lifecycleData.getStartTime());
        }
        this.lifecycleDataList.add(lifecycleData);
    }

    public String getTooltipMessage(int x) {
        double time = this.pixelToSecond(x);
        int size = this.lifecycleDataList.size();
        if (size == 0 || this.lifecycleDataList.get(0).getStartTime() > time && this.lifecycleDataList.get(size - 1).getEndTime() < time) {
            return null;
        }
        for (LifecycleData data : this.lifecycleDataList) {
            double endTime = data.getEndTime();
            if (endTime == -1.0) {
                endTime = this.totalEndTime;
            }
            if (!(time >= data.getStartTime()) || !(time <= endTime)) continue;
            return data.getText();
        }
        return null;
    }

    public void clear() {
        this.visibleStartTime = 0.0;
        this.totalEndTime = 0.0;
        this.lifecycleDataList.clear();
        this.redraw();
    }

    private double secondToPixel(double second) {
        return (second - this.visibleStartTime) * (double)this.scale * 5.0;
    }

    private double pixelToSecond(int pixel) {
        return (double)pixel / (double)this.scale / 5.0 + this.visibleStartTime;
    }
}

