/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTFunctionDefinition
extends ASTNode
implements IASTFunctionDefinition,
IASTAmbiguityParent {
    private IASTDeclSpecifier declSpecifier;
    private IASTFunctionDeclarator declarator;
    private IASTStatement bodyStatement;
    private ICFunctionScope scope;

    public CASTFunctionDefinition() {
    }

    public CASTFunctionDefinition(IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, IASTStatement bodyStatement) {
        this.setDeclSpecifier(declSpecifier);
        this.setDeclarator(declarator);
        this.setBody(bodyStatement);
    }

    public CASTFunctionDefinition copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    public CASTFunctionDefinition copy(IASTNode.CopyStyle style) {
        CASTFunctionDefinition copy = new CASTFunctionDefinition();
        copy.setDeclSpecifier(this.declSpecifier == null ? null : this.declSpecifier.copy(style));
        if (this.declarator != null) {
            IASTDeclarator outer = CVisitor.findOutermostDeclarator(this.declarator);
            outer = outer.copy(style);
            copy.setDeclarator((IASTFunctionDeclarator)CVisitor.findTypeRelevantDeclarator(outer));
        }
        copy.setBody(this.bodyStatement == null ? null : this.bodyStatement.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpecifier = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public IASTFunctionDeclarator getDeclarator() {
        return this.declarator;
    }

    public void setDeclarator(IASTFunctionDeclarator declarator) {
        this.assertNotFrozen();
        this.declarator = declarator;
        if (declarator != null) {
            IASTDeclarator outerDtor = CVisitor.findOutermostDeclarator(declarator);
            outerDtor.setParent(this);
            outerDtor.setPropertyInParent(DECLARATOR);
        }
    }

    public IASTStatement getBody() {
        return this.bodyStatement;
    }

    public void setBody(IASTStatement statement) {
        this.assertNotFrozen();
        this.bodyStatement = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(FUNCTION_BODY);
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CFunctionScope(this);
        }
        return this.scope;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        IASTDeclarator outerDtor = CVisitor.findOutermostDeclarator(this.declarator);
        if (outerDtor != null && !outerDtor.accept(action)) {
            return false;
        }
        if (this.bodyStatement != null && !this.bodyStatement.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.bodyStatement == child) {
            other.setPropertyInParent(this.bodyStatement.getPropertyInParent());
            other.setParent(this.bodyStatement.getParent());
            this.bodyStatement = (IASTStatement)other;
        }
    }
}

