/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.File;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;

final class IncludeSearchPathElement {
    private static final boolean NON_SLASH_SEPARATOR = File.separatorChar != '/';
    public static final String FRAMEWORK_VAR = "__framework__";
    public static final String FILE_VAR = "__header__";
    private final String fPath;
    private final boolean fForQuoteIncludesOnly;
    private final boolean fIsFrameworkDirectory;

    IncludeSearchPathElement(String path, boolean forQuoteIncludesOnly) {
        this.fPath = path;
        this.fForQuoteIncludesOnly = forQuoteIncludesOnly;
        this.fIsFrameworkDirectory = path.indexOf(95) != -1 && path.indexOf(FRAMEWORK_VAR) != -1 && path.indexOf(FILE_VAR) != -1;
    }

    public boolean isForQuoteIncludesOnly() {
        return this.fForQuoteIncludesOnly;
    }

    public String getLocation(String includeDirective) {
        if (this.fIsFrameworkDirectory) {
            int firstSep = this.firstSeparator(includeDirective);
            if (firstSep < 1) {
                return null;
            }
            String framework = includeDirective.substring(0, firstSep);
            String file = includeDirective.substring(firstSep + 1);
            if (file.length() == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder(this.fPath);
            this.replace(buf, FRAMEWORK_VAR, framework);
            this.replace(buf, FILE_VAR, file);
            return ScannerUtility.reconcilePath(buf.toString());
        }
        return ScannerUtility.createReconciledPath(this.fPath, includeDirective);
    }

    private int firstSeparator(String path) {
        int firstSep = path.indexOf(47);
        if (NON_SLASH_SEPARATOR) {
            firstSep = Math.max(firstSep, path.indexOf(File.separatorChar));
        }
        return firstSep;
    }

    private void replace(StringBuilder buf, String find, String replace) {
        int idx = buf.indexOf(find);
        if (idx >= 0) {
            buf.replace(idx, idx + find.length(), replace);
        }
    }
}

