/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.manager;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.tizen.dynamicanalyzer.cli.manager.ProcessManagerJMXAgent;
import org.tizen.dynamicanalyzer.cli.manager.ProcessManagerMBean;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.InternalLogger;
import org.tizen.dynamicanalyzer.util.Logger;

public class ClientUtils {
    private static final String PMA_CANONICAL_NAME = ProcessManagerJMXAgent.class.getCanonicalName();
    private static final String PMA_LIBRARY_PATH = new File(ProcessManagerJMXAgent.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
    private static final int CONNECTION_PORT = 6789;
    private static final int CONNECTION_TRY_COUNT = 10;
    private static final int CONNECTION_TRY_DELAY_MS = 100;

    private static File getLogFile() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH-mm-ss");
        String logPostfix = dateFormat.format(new Date());
        String logFilePath = InternalLogger.getInstance().getLogPath(PathManager.DA_LOG_PATH, "da_log_process_manager_" + logPostfix);
        return logFilePath != null ? new File(logFilePath) : null;
    }

    private static void startPMAgent() throws IOException {
        String currentClasspath = System.getProperty("java.class.path");
        Logger.debug((String)"Current classpath: %s", (Object[])new Object[]{currentClasspath});
        List<String> commandLine = Arrays.asList("java", "-Dcom.sun.management.jmxremote.port=6789", "-Dcom.sun.management.jmxremote.authenticate=false", "-Dcom.sun.management.jmxremote.ssl=false", "-Dcom.sun.management.jmxremote.local.only=true", "-classpath", PMA_LIBRARY_PATH + CommonUtil.CLASSPATH_SEPARATOR + currentClasspath, PMA_CANONICAL_NAME);
        ProcessBuilder pb = new ProcessBuilder(commandLine);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        File logFile = ClientUtils.getLogFile();
        if (logFile == null) {
            throw new IOException("Failed to create log file");
        }
        Logger.info((String)"Redirecting ProcessManager output to: %s", (Object[])new Object[]{logFile.getAbsolutePath()});
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(logFile));
        pb.start();
    }

    public static ProcessManagerMBean getProcessManagerProxy(boolean autostartPM) throws ConnectException {
        JMXConnector jmxConnector;
        ObjectName pmName;
        JMXServiceURL jmxURL;
        block18: {
            try {
                jmxURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:6789/jmxrmi");
                pmName = new ObjectName("dynamicanalyzer.tizen.org:type=ProcessManager");
            }
            catch (MalformedURLException | MalformedObjectNameException e) {
                Logger.error((String)"Wrong JMX Service URL or Object Name: %s.", (Object[])new Object[]{e.toString()});
                throw new AssertionError((Object)("Wrong JMX Service URL or Object Name: " + e.toString()));
            }
            jmxConnector = null;
            try {
                jmxConnector = JMXConnectorFactory.connect(jmxURL);
            }
            catch (IOException e) {
                if (autostartPM) break block18;
                Logger.error((String)"Can't connect to the JMX agent: %s.", (Object[])new Object[]{e});
                throw new ConnectException("Can't connect to the JMX agent.", e);
            }
        }
        if (jmxConnector == null) {
            try {
                ClientUtils.startPMAgent();
            }
            catch (IOException e) {
                Logger.error((String)"Can't start JMX agent: %s.", (Object[])new Object[]{e});
                throw new ConnectException("Can't start JMX agent.", e);
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Logger.warning((Object)"Connection to the JMX agent was interrupted.");
                    throw new ConnectException("Connection to the JMX agent was interrupted.");
                }
                try {
                    Logger.info((String)"Connecting to the JMX agent (try #%d).", (Object[])new Object[]{i});
                    jmxConnector = JMXConnectorFactory.connect(jmxURL);
                    break;
                }
                catch (IOException e) {
                    if (i != 9) continue;
                    Logger.error((String)"Can't connect to the JMX agent after #%d tries: %s.", (Object[])new Object[]{10, e.toString()});
                    throw new ConnectException("Can't connect to the JMX agent after #10 tries.", e);
                }
            }
        }
        Logger.info((Object)"Successfully connected to the JMX agent.");
        MBeanServerConnection mbsConnection = null;
        for (int i = 0; i < 10; ++i) {
            try {
                Logger.info((String)"Connecting to the MBean Server (try #%d).", (Object[])new Object[]{i});
                mbsConnection = jmxConnector.getMBeanServerConnection();
                break;
            }
            catch (IOException e) {
                if (i == 9) {
                    Logger.error((String)"Can't connect to the MBean Server after #%d tries: %s.", (Object[])new Object[]{10, e.toString()});
                    throw new ConnectException("Can't connect to the MBean Server after #10tries.", e);
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e2) {
                    Logger.warning((Object)"Connection to the MBean Server was interrupted.");
                    throw new ConnectException("Connection to the MBean Server was interrupted.");
                }
            }
        }
        Logger.info((Object)"Successfully connected to the MBean Server.");
        ProcessManagerMBean pmProxy = JMX.newMBeanProxy(mbsConnection, pmName, ProcessManagerMBean.class);
        Logger.info((Object)"Successfully connected to the Process Manager.");
        return pmProxy;
    }
}

