/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.tizen.dynamicanalyzer.cli.utils.Message;
import org.tizen.dynamicanalyzer.util.Logger;

public class Communicator {
    ObjectOutputStream oos;
    ObjectInputStream ois;

    public Communicator(ObjectInputStream ois, ObjectOutputStream oos) {
        this.ois = ois;
        this.oos = oos;
    }

    public synchronized void sendMessage(Message message) throws IOException {
        Logger.debug((Object)("sending " + (Object)((Object)message.getMessageType())));
        this.oos.writeObject(message);
        this.oos.flush();
        Logger.debug((Object)("sent " + (Object)((Object)message.getMessageType())));
    }

    public void sendMessage(long tid, Message.MessageType messageT, String ... args) throws IOException {
        this.sendMessage(new Message(tid, messageT, args));
    }

    public Message getMessage() {
        try {
            Object rawObj = this.ois.readObject();
            if (!(rawObj instanceof Message)) {
                return null;
            }
            return (Message)rawObj;
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.debug((Object)"Stream closed");
            return null;
        }
    }

    public void stop() {
        try {
            this.oos.close();
            this.ois.close();
        }
        catch (IOException e) {
            Logger.error((Object)e.getMessage());
        }
    }
}

