/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmListProperties
extends HierarchyUIObjectProperties {
    private boolean horizontal;
    private String selectMode;
    private boolean focusOnSelection;
    private boolean multiSelect;
    private String multiSelectMode;
    private String mode;

    public ElmListProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.horizontal = parser.getBoolean();
        this.selectMode = this.getSelectModeMessage(parser.getChar());
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.focusOnSelection = parser.getBoolean();
        }
        this.multiSelect = parser.getBoolean();
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.multiSelectMode = this.getMultiSelectModeMessage(parser.getChar());
        }
        this.mode = this.getModeMessage(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("horizontal", Boolean.toString(this.horizontal)));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("focusOnSelection", Boolean.toString(this.focusOnSelection)));
        }
        properties.add(new PropertyValue("multiSelect", Boolean.toString(this.multiSelect)));
        properties.add(new PropertyValue("mode", this.mode));
        properties.add(new PropertyValue("selectMode", this.selectMode));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("multiSelectMode", this.multiSelectMode));
        }
        return properties;
    }

    private String getSelectModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_OBJECT_SELECT_MODE_DEFAULT";
            }
            case 1: {
                return "ELM_OBJECT_SELECT_MODE_ALWAYS";
            }
            case 2: {
                return "ELM_OBJECT_SELECT_MODE_NONE";
            }
            case 3: {
                return "ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY";
            }
            case 4: {
                return "ELM_OBJECT_SELECT_MODE_MAX";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getMultiSelectModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_OBJECT_MULTI_SELECT_MODE_DEFAULT";
            }
            case 1: {
                return "ELM_OBJECT_MULTI_SELECT_MODE_WITH_CONTROL";
            }
            case 2: {
                return "ELM_OBJECT_MULTI_SELECT_MODE_MAX";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_LIST_COMPRESS";
            }
            case 1: {
                return "ELM_LIST_SCROLL";
            }
            case 2: {
                return "ELM_LIST_LIMIT";
            }
            case 3: {
                return "ELM_LIST_EXPAND";
            }
            case 4: {
                return "ELM_LIST_LAST";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

