/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.file;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class FileChartRenderer
extends DAChartRenderer {
    protected void drawToGc(GC gc, DAChart chart) {
        if (!this.preDraw(gc, chart)) {
            return;
        }
        int i = 0;
        while (i < this.seriesList.size()) {
            this.drawSeries(gc, (DAChartSeries)this.seriesList.get(i), i, this.seriesList.size());
            ++i;
        }
    }

    private void drawSeries(GC gc, DAChartSeries series, int seriesIndex, int seriesSize) {
        List seriesItems = series.getSeriesItemList();
        if (seriesItems == null) {
            return;
        }
        int seriesItemSize = seriesItems.size();
        if (seriesItemSize < 1) {
            return;
        }
        int index = series.getPrevIndexByXvalue(this.plot.getVisibleStartX());
        if (index < 0) {
            index = 0;
        }
        Color DIAGONAL_BOX_COLOR = ColorResources.WHITE;
        int margin = (int)((double)this.r.height * 0.2 / (double)(seriesSize + 1));
        int areaHeight = (this.r.height - margin * (seriesSize + 1)) / seriesSize;
        int pixelStartY = margin * (seriesIndex + 1) + areaHeight * seriesIndex;
        ArrayList<DAChartSeriesItem> barSeriesItems = new ArrayList<DAChartSeriesItem>();
        int i = 0;
        while (i < seriesItemSize) {
            DAChartSeriesItem seriesItem = (DAChartSeriesItem)seriesItems.get(i);
            DAChartSeriesItem endSeriesItem = null;
            int type = (int)seriesItem.getY();
            if (type == 0) {
                int startCount = 1;
                int ii = i + 1;
                while (ii < seriesItemSize) {
                    DAChartSeriesItem nextSeriesItem = (DAChartSeriesItem)seriesItems.get(ii);
                    int nextType = (int)nextSeriesItem.getY();
                    if (nextType == 0) {
                        ++startCount;
                    } else if (nextType == 1 && --startCount == 0) {
                        endSeriesItem = nextSeriesItem;
                        break;
                    }
                    ++ii;
                }
                Color foreGroundColor = seriesItem.getGradationForegroundColor();
                Color backGroundcolor = seriesItem.getColor();
                gc.setForeground(foreGroundColor);
                gc.setBackground(backGroundcolor);
                int pixelStartX = this.plot.getXPixelFromX(seriesItem.getX(), this.r);
                int pixelWidth = endSeriesItem != null ? this.plot.getXPixelFromX(endSeriesItem.getX(), this.r) - pixelStartX : this.plot.getXPixelFromX(this.plot.getValidEndX(), this.r) - pixelStartX;
                if (pixelWidth == 0) {
                    pixelWidth = 1;
                }
                gc.fillRectangle(pixelStartX, pixelStartY, pixelWidth, areaHeight);
                if (seriesItem.getDiagonal()) {
                    int diagonalBoxSize = areaHeight / 16;
                    gc.setForeground(DIAGONAL_BOX_COLOR);
                    gc.setBackground(DIAGONAL_BOX_COLOR);
                    int j = 0;
                    while (j < 16) {
                        int boxY = pixelStartY + diagonalBoxSize * j;
                        int k = 3 - j % 4 - j / 4;
                        while (k < pixelWidth) {
                            int boxX = diagonalBoxSize * k + pixelStartX;
                            if (pixelStartX <= boxX && boxX <= pixelWidth + pixelStartX - diagonalBoxSize) {
                                gc.fillRectangle(boxX, boxY, diagonalBoxSize, diagonalBoxSize);
                            }
                            k += 3;
                        }
                        ++j;
                    }
                }
            } else if (2 == type) {
                barSeriesItems.add(seriesItem);
            }
            ++i;
        }
        i = 0;
        while (i < barSeriesItems.size()) {
            DAChartSeriesItem barSeriesItem = (DAChartSeriesItem)barSeriesItems.get(i);
            Color foreGroundColor = barSeriesItem.getGradationForegroundColor();
            Color backGroundcolor = barSeriesItem.getColor();
            gc.setForeground(foreGroundColor);
            gc.setBackground(backGroundcolor);
            int pixelStartX = this.plot.getXPixelFromX(barSeriesItem.getX(), this.r);
            gc.fillRectangle(pixelStartX, pixelStartY, 1, areaHeight);
            ++i;
        }
    }

    protected void drawTooltip(GC gc) {
        DAChartPlotTooltip tooltip = this.plot.getTooltip();
        if (tooltip == null || !tooltip.shouldBeDrawn() || tooltip.getStartVal() == -1.0) {
            return;
        }
        gc.setFont(tooltip.getFont());
        ArrayList<String> tooltipTexts = new ArrayList<String>();
        ArrayList<String> tooltipTimes = new ArrayList<String>();
        ArrayList<Color> tooltipColor = new ArrayList<Color>();
        int textWidthMax = 0;
        double realXVal = tooltip.getStartVal();
        int tooltipSize = 0;
        int seriesIndex = (int)((double)this.seriesList.size() * tooltip.getYPosRatio());
        DAChartSeries series = (DAChartSeries)this.seriesList.get(seriesIndex);
        int index = series.getPrevIndexByXvalue(realXVal);
        String text = "";
        String time = "";
        if (index < 0) {
            return;
        }
        double xVal = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getX();
        text = String.valueOf(text) + series.getName() + ": ";
        time = String.valueOf(time) + this.toTimeFormat(xVal);
        text = series.isSummarizeTooltip() && this.checkOverlapFromPrevItem(series, index) ? String.valueOf(text) + series.getSummarizeString() : String.valueOf(text) + ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getTooltipText();
        gc.setForeground(tooltip.getLineColor());
        gc.setLineStyle(3);
        gc.setLineWidth(1);
        gc.drawLine(this.plot.getXPixelFromX(xVal), 0, this.plot.getXPixelFromX(xVal), this.r.height);
        gc.setLineStyle(6);
        Color color = ((DAChartSeriesItem)series.getSeriesItemList().get(index)).getColor();
        tooltipTexts.add(text);
        tooltipTimes.add(time);
        tooltipColor.add(color);
        int textWidth = gc.textExtent((String)text).x + 20 + gc.textExtent((String)time).x;
        if (textWidthMax < textWidth) {
            textWidthMax = textWidth;
        }
        int preTextWidthMargin = 14;
        int startX = this.getTooltipStartX(realXVal, textWidthMax + preTextWidthMargin, 4);
        int totalHeight = !tooltipTexts.isEmpty() ? gc.textExtent((String)((String)tooltipTexts.get((int)0))).y + 4 + 4 : 18;
        tooltipSize = this.seriesList.size();
        int heightPerSeries = this.r.height / tooltipSize;
        int currentSeries = (int)(tooltip.getYPosRatio() * (double)tooltipSize) + 1;
        int startY = this.r.y + heightPerSeries * (currentSeries - 1) + heightPerSeries / 2 - totalHeight / 2;
        if (this.r.height - startY - totalHeight < 0 && (startY = this.r.height - totalHeight - 1) < 0) {
            startY = 4;
        }
        gc.setAlpha(150);
        gc.setBackground(tooltip.getBackgroundColor());
        gc.setForeground(tooltip.getForegroundColor());
        gc.fillGradientRectangle(startX, startY, preTextWidthMargin + textWidthMax + 4, totalHeight, true);
        gc.setAlpha(255);
        gc.setForeground(tooltip.getLineColor());
        gc.drawRoundRectangle(startX, startY, preTextWidthMargin + textWidthMax + 4, totalHeight, 5, 5);
        gc.setFont(tooltip.getFont());
        int y = startY + 4;
        Color col = (Color)tooltipColor.get(0);
        if (col == null) {
            gc.setBackground(series.getColor());
        } else {
            gc.setBackground(col);
        }
        gc.fillRectangle(startX + 4, y + 5 - 3, 6, 6);
        gc.setBackground(tooltip.getBackgroundColor());
        gc.setForeground(tooltip.getTextColor());
        gc.drawText((String)tooltipTexts.get(0), startX + 4 + 6 + 4, y, 3);
        gc.setForeground(tooltip.getTimeColor());
        String timeStr = (String)tooltipTimes.get(0);
        gc.drawText((String)tooltipTimes.get(0), startX + 4 + 6 + 4 + textWidthMax - 4 - gc.textExtent((String)timeStr).x, y, 3);
    }
}

