/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.resources.ColorResources;

public class IconView
extends Composite {
    protected Canvas canvas = null;
    protected List<Image> images = null;
    protected String[] tooltips = null;
    protected int imageCount = 0;
    protected Image selectedImage = null;
    protected Color bg = ColorResources.RED;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Rectangle rect = IconView.this.canvas.getBounds();
            if (IconView.this.selectedImage != null && !IconView.this.selectedImage.isDisposed()) {
                e.gc.drawImage(IconView.this.selectedImage, rect.x, rect.y);
            } else {
                e.gc.setBackground(IconView.this.bg);
                e.gc.fillRectangle(rect);
            }
        }
    };

    public IconView(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.canvas = new Canvas((Composite)this, 0x60000000);
        this.canvas.addPaintListener(this.paintListener);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)data);
    }

    public List<Image> getImages() {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        return this.images;
    }

    public void setTooltips(String[] strings) {
        if (strings != null) {
            this.tooltips = strings;
        }
    }

    public void setImages(List<Image> input) {
        this.getImages().addAll(input);
        this.imageCount = input.size();
    }

    public void setSelection(int sel) {
        this.selectedImage = this.imageCount > 0 && sel < this.imageCount ? this.getImages().get(sel) : null;
        if (this.tooltips != null && this.tooltips.length > sel) {
            this.canvas.setToolTipText(this.tooltips[sel]);
        } else {
            this.canvas.setToolTipText(null);
        }
    }

    public void clear() {
        this.getImages().clear();
        this.tooltips = null;
        this.imageCount = this.getImages().size();
        this.selectedImage = null;
        this.canvas.redraw();
    }

    public void setBackgroundColor(Color color) {
        this.bg = color;
    }

    public void update() {
        this.canvas.redraw();
    }
}

