/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.info.screenshot;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.database.DBColumn;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.DBTable;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.project.ImageInfo;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ProcessProfileData;
import org.tizen.dynamicanalyzer.swap.model.data.ScreenShotData;
import org.tizen.dynamicanalyzer.swap.model.data.SystemData;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenShotDBTable;
import org.tizen.dynamicanalyzer.ui.info.screenshot.SocketClient;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class ScreenshotDataManager
extends PageDataManager {
    private static final String SCREENSHOT_QUERY = "select %s from %s order by %s";
    private static ScreenshotDataManager instance = new ScreenshotDataManager();
    private ScreenShotDBTable screenShotDBTable = null;
    private DBInserter screenShotDBInserter = null;
    private List<Long> lastCpuRate = null;
    private long lastProcessMemory = 0L;
    private long lastStartTime = 0L;
    private List<Image> imageList = new ArrayList<Image>();
    private List<String> fileNameList = new ArrayList<String>();

    private ScreenshotDataManager() {
        this.lastCpuRate = new ArrayList<Long>();
        this.screenShotDBTable = new ScreenShotDBTable();
        this.screenShotDBInserter = this.makeInserter(this.screenShotDBTable);
    }

    public static ScreenshotDataManager getInstance() {
        return instance;
    }

    public List<Image> getImageList() {
        return this.imageList;
    }

    public List<String> getFileNameList() {
        return this.fileNameList;
    }

    public Image getImage(int index) {
        return this.imageList.get(index);
    }

    public String getfileName(int index) {
        return this.fileNameList.get(index);
    }

    public void clear() {
        this.imageList.clear();
        this.fileNameList.clear();
    }

    public List<Long> getLastCpuRate() {
        return this.lastCpuRate;
    }

    public long getLastProcessMemory() {
        return this.lastProcessMemory;
    }

    public long getLastStartTime() {
        return this.lastStartTime;
    }

    public DBTable getScreenShotTable() {
        return this.screenShotDBTable;
    }

    private void makeScreenShotData(Logs screenShotLogs) {
        if (screenShotLogs != null && screenShotLogs.getRawLogs() != null && !screenShotLogs.getRawLogs().isEmpty()) {
            List<LogData> screenShotLogList = screenShotLogs.getRawLogs();
            ArrayList screenShotDataList = new ArrayList();
            int size = screenShotLogList.size();
            int i = 0;
            while (i < size) {
                ScreenShotData log = (ScreenShotData)screenShotLogList.get(i);
                ArrayList<Object> dbScreenShotData = new ArrayList<Object>();
                String imgPathLog = null;
                String[] splitedImgPath = null;
                DeviceInfo curDev = Global.getCurrentDeviceInfo();
                if (curDev.isEmulator() && SocketClient.getInstance().isConnected()) {
                    imgPathLog = curDev.emulatorScreenshot.getFilePath();
                    splitedImgPath = AnalyzerUtil.splitFilePath(imgPathLog, File.separator);
                } else {
                    imgPathLog = log.getImageFilePath();
                    splitedImgPath = AnalyzerUtil.splitFilePath(imgPathLog, "/");
                }
                String fileName = splitedImgPath[splitedImgPath.length - 1];
                dbScreenShotData.add(log.getTime());
                dbScreenShotData.add(fileName);
                dbScreenShotData.add(log.getOrientation());
                screenShotDataList.add(dbScreenShotData);
                ImageInfo imgInfo = new ImageInfo();
                imgInfo.setTime(log.getTime());
                imgInfo.setFileName(fileName);
                imgInfo.setOrientation(log.getOrientation());
                Global.getProject().addImageInfo(imgInfo);
                ++i;
            }
            this.screenShotDBInserter.pushData(screenShotDataList);
        }
    }

    private void makeSystemData(Logs systemDataLogs) {
        this.lastCpuRate.clear();
        if (systemDataLogs != null && systemDataLogs.getRawLogs() != null && !systemDataLogs.getRawLogs().isEmpty()) {
            List<LogData> inputs = systemDataLogs.getRawLogs();
            int lastIndex = inputs.size() - 1;
            SystemData input = (SystemData)inputs.get(lastIndex);
            double[] cpuRates = input.getCpuLoad();
            int i = 0;
            while (i < cpuRates.length) {
                this.lastCpuRate.add(new Long((long)cpuRates[i]));
                ++i;
            }
            ProcessProfileData[] processInfoList = input.getProcessProfileDataList();
            if (processInfoList != null) {
                this.lastProcessMemory = 0L;
                int i2 = 0;
                while (i2 < processInfoList.length) {
                    this.lastProcessMemory += processInfoList[i2].getResidentMemory();
                    ++i2;
                }
            }
            this.lastStartTime = input.getTime();
        }
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs systemDataLogs = pack.getLogs(5);
        Logs screenShotLogs = pack.getLogs(262);
        this.makeSystemData(systemDataLogs);
        this.makeScreenShotData(screenShotLogs);
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        StringBuilder columnstr = new StringBuilder();
        List<DBColumn> columnList = this.screenShotDBTable.getColumns();
        int columnsize = columnList.size();
        int i = 0;
        while (i < columnsize) {
            columnstr.append(columnList.get(i).getName());
            if (i != columnsize - 1) {
                columnstr.append(", ");
            }
            ++i;
        }
        String querystr = String.format(SCREENSHOT_QUERY, new Object[]{columnstr.toString(), this.screenShotDBTable.getTableName(), ScreenShotDBTable.COLUMN.CAPTURE_TIME});
        ResultSet rs = SqlConnectionManager.executeQueryRS(querystr);
        if (rs != null) {
            try {
                while (rs.next()) {
                    ImageInfo img = new ImageInfo();
                    img.setTime(rs.getLong(1));
                    img.setFileName(rs.getString(2));
                    img.setOrientation(rs.getInt(3));
                    imageList.add(img);
                }
            }
            catch (SQLException e) {
                Logger.exception((Throwable)e);
            }
            SqlConnectionManager.releaseResultSet(rs);
        }
        Global.getProject().buildImageInfoFrom(imageList);
    }

    public void addScreenshotData(Image image, String fileName) {
        this.imageList.add(image);
        this.fileNameList.add(fileName);
    }
}

