/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.database.DBInserter;
import org.tizen.dynamicanalyzer.database.IResultSet;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.MemoryData;
import org.tizen.dynamicanalyzer.ui.memory.data.MemAllocDBTable;
import org.tizen.dynamicanalyzer.ui.memory.data.MemFreeDBTable;
import org.tizen.dynamicanalyzer.util.Logger;

public class HeapDataManager
extends PageDataManager {
    private static HeapDataManager instance = new HeapDataManager();
    private final int MEM_API_TYPE_ALLOC = 0;
    private final int MEM_API_TYPE_FREE = 1;
    private int REALLOC_ID;
    private MemAllocDBTable allocateDBTable = new MemAllocDBTable();
    private MemFreeDBTable freeDBTable = new MemFreeDBTable();
    private DBInserter allocateDBInserter = this.makeInserter(this.allocateDBTable);
    private DBInserter freeDBInserter = this.makeInserter(this.freeDBTable);
    private List<List<Object>> memoryAllocDataList;
    private List<List<Object>> memoryfreeDataList;

    public static HeapDataManager getInstance() {
        return instance;
    }

    @Override
    protected void makeData(LogPackage pack) {
        this.REALLOC_ID = Global.getFunctionID("realloc");
        Logs allocatedlogs = this.getLogsFromLogPackage(pack, 257);
        this.makeHeapData(allocatedlogs);
    }

    private Logs getLogsFromLogPackage(LogPackage logPack, int logCenterConstants) {
        Logs logs = logPack.getLogs(logCenterConstants);
        if (logs == null || logs.getRawLogs().size() == 0) {
            return null;
        }
        return logs;
    }

    private boolean isAllocatorAddrSupported() {
        Protocol projectProtocol = Global.getCurrentProtocol();
        return projectProtocol.getVersionNum() >= Protocol.VERSION_42.getVersionNum();
    }

    private long getAllocatorAddress(MemoryData logData) {
        if (!this.isAllocatorAddrSupported()) {
            return 0L;
        }
        int reserved1 = logData.getReserved1();
        int reserved2 = logData.getReserved2();
        long allocatorAddress = (long)reserved2 << 32 | (long)reserved1 & 0xFFFFFFFFL;
        return allocatorAddress;
    }

    private void makeHeapData(Logs alloclogs) {
        if (alloclogs == null) {
            return;
        }
        this.memoryAllocDataList = new ArrayList<List<Object>>();
        this.memoryfreeDataList = new ArrayList<List<Object>>();
        for (LogData data : alloclogs.getRawLogs()) {
            MemoryData logData = (MemoryData)data;
            long errorNo = logData.getErrno();
            if (errorNo != 0L) continue;
            int memApiType = logData.getMemoryApiType();
            int pid = logData.getPid();
            long calleraddress = logData.getCallerPcAddr();
            int binaryid = Global.getBinaryID(pid, logData.getTime(), calleraddress);
            if (memApiType == 0) {
                long allocatorAddr = this.getAllocatorAddress(logData);
                this.makeAllocData(logData, binaryid, allocatorAddr);
                continue;
            }
            if (1 != memApiType) continue;
            this.makeFreeData(logData, binaryid);
        }
        if (!this.memoryAllocDataList.isEmpty()) {
            this.allocateDBInserter.pushData(this.memoryAllocDataList);
        }
        if (!this.memoryfreeDataList.isEmpty()) {
            this.freeDBInserter.pushData(this.memoryfreeDataList);
        }
    }

    private void makeAllocData(MemoryData mData, int binaryid, long allocatorAddr) {
        ArrayList<Number> dbAllocData = new ArrayList<Number>();
        int pid = mData.getPid();
        int tid = mData.getTid();
        long address = mData.getAddress();
        long mallocsize = mData.getSize();
        if (this.REALLOC_ID == mData.getApiId()) {
            try {
                Long freeaddress = Long.parseLong(mData.getArgs().replace("0x", "").split(",")[0], 16);
                this.makeFreeData(mData, freeaddress, binaryid);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.warning((String)"realloc address invalide : %s", (Object[])new Object[]{mData.getArgs()});
            }
        }
        dbAllocData.add(mData.getSeq());
        dbAllocData.add(pid);
        dbAllocData.add(tid);
        dbAllocData.add(mData.getApiId());
        dbAllocData.add(mData.getMemoryApiType());
        dbAllocData.add(address);
        dbAllocData.add(mData.getTime());
        dbAllocData.add(mData.getCallerPcAddr());
        dbAllocData.add(binaryid);
        dbAllocData.add(mData.getMsgID());
        dbAllocData.add(mallocsize);
        dbAllocData.add(allocatorAddr == 0L ? null : Long.valueOf(allocatorAddr));
        this.memoryAllocDataList.add(dbAllocData);
    }

    private void makeFreeData(MemoryData mData, int binaryid) {
        this.makeFreeData(mData, mData.getAddress(), binaryid);
    }

    private void makeFreeData(MemoryData mData, Long address, int binaryid) {
        ArrayList<Number> dbFreeData = new ArrayList<Number>();
        int pid = mData.getPid();
        dbFreeData.add(mData.getSeq());
        dbFreeData.add(pid);
        dbFreeData.add(mData.getMsgID());
        dbFreeData.add(mData.getTime());
        dbFreeData.add(address);
        dbFreeData.add(binaryid);
        this.memoryfreeDataList.add(dbFreeData);
    }

    public List<Object> getAllocationRowBySeqFromDB(long seqNum) {
        String where = "WHERE SEQUENCE_NUMBER = " + Long.toString(seqNum);
        List<List<Object>> queryResult = this.allocateDBTable.selectRequiredColumns(where);
        if (queryResult.size() != 1) {
            Logger.error((Object)"Stored data was corrupted!");
            return null;
        }
        return queryResult.get(0);
    }

    public Long getAllocatorAddrBySeqFromDB(long seqNum) {
        if (!this.isAllocatorAddrSupported()) {
            return 0L;
        }
        String where = "WHERE SEQUENCE_NUMBER = " + Long.toString(seqNum);
        String columnName = MemAllocDBTable.COLUMN.ALLOCATOR_ADDRESS.name;
        List<List<Object>> queryResult = this.allocateDBTable.selectData(new ArrayList<String>(Arrays.asList(columnName)), where, new IResultSet(){

            @Override
            public List<Object> extractDataFromResultSet(ResultSet rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                try {
                    if (rs.getMetaData().getColumnCount() > 0) {
                        row.add(rs.getLong(1));
                    } else {
                        row.add(0L);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                }
                return row;
            }
        });
        if (queryResult.size() != 1) {
            Logger.warning((Object)("Could't extract " + columnName + " for seq#" + seqNum + " from " + "MEM_ALLOC_DB"));
            return 0L;
        }
        return (Long)queryResult.get(0).get(0);
    }
}

