/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.memory.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MemoryPageLabels;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPage;
import org.tizen.dynamicanalyzer.ui.memory.MemoryPersistentAllocationsTableView;
import org.tizen.dynamicanalyzer.ui.memory.data.HeapDataProcessor;
import org.tizen.dynamicanalyzer.ui.memory.data.util.Query;
import org.tizen.dynamicanalyzer.ui.memory.table.MemoryPersistentAllocationsTableIndex;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DefaultTableComparator;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.chart.IntervalManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;
import org.tizen.dynamicanalyzer.widgets.timeline.MarkerManager;

public class MemoryPersistentAllocationsTable
extends DATableComposite {
    private boolean onlyLeaks;
    Query lastPartQuery = null;
    CompletableFuture<List<TableInput>> partDataTask = null;
    CompletableFuture<List<TableInput>> wholeDataTask = null;
    List<TableInput> processingStub;

    public MemoryPersistentAllocationsTable(Composite parent, int style, int tableStyle, boolean onlyLeaks) {
        super(parent, style, tableStyle);
        this.onlyLeaks = onlyLeaks;
        this.setTableName(MemoryPageLabels.MEMORY_ALLOCATION_TRACE_VIEW_TITLE);
        this.setComparator(new DefaultTableComparator());
        this.setSortTypes(MemoryPersistentAllocationsTableIndex.getSortTypes());
        this.setColumnAlignment(MemoryPersistentAllocationsTableIndex.getAlignments());
        this.setColumns(MemoryPersistentAllocationsTableIndex.getNames());
        int[] columnSizes = MemoryPersistentAllocationsTableIndex.getSizes();
        this.setColumnSize(columnSizes);
        this.setTableToolTipEnable(false);
        this.table.getColumn(MemoryPersistentAllocationsTableIndex.SEQ.getIndex()).setVisible(false);
        if (onlyLeaks) {
            this.table.getColumn(MemoryPersistentAllocationsTableIndex.LEAK.getIndex()).setVisible(false);
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = ((Grid)e.widget).getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                int size = items.length;
                List<Object> startData = ((DATableDataFormat)items[0].getData()).getData();
                List<Object> endData = ((DATableDataFormat)items[size - 1].getData()).getData();
                long startTime = (Long)startData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                long endTime = (Long)endData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                Toolbar.INSTANCE.setChartDragStartTime(startTime);
                Toolbar.INSTANCE.setChartDragEndTime(endTime);
                Toolbar.INSTANCE.setDlogSelection(false);
                Composite view = MemoryPersistentAllocationsTable.this.table.getParent();
                while (view != null && !(view instanceof MemoryPersistentAllocationsTableView)) {
                    view = view.getParent();
                }
                if (view == null) {
                    Logger.warning((Object)"Could not find parent view");
                    return;
                }
                DASelectionData data = new DASelectionData(MemoryPage.persistentAllocsViewID, startTime, endTime, items, (Control)MemoryPersistentAllocationsTable.this.table);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)data);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                GridItem[] ti = ((Grid)e.widget).getSelection();
                if (ti == null || ti.length == 0) {
                    return;
                }
                List<Object> markerData = ((DATableDataFormat)ti[0].getData()).getData();
                long markerTime = (Long)markerData.get(MemoryPersistentAllocationsTableIndex.TIMESTAMP.getIndex());
                MarkerManager.INSTANCE.addMarker(markerTime);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.processingStub = Arrays.asList(this.makeProcessingStub());
    }

    private TableInput makeProcessingStub() {
        DATableDataFormat tableData = new DATableDataFormat(0L);
        ArrayList<String> text = new ArrayList<String>();
        ArrayList<Integer> data = new ArrayList<Integer>();
        text.add("");
        data.add(0);
        text.add(AnalyzerLabels.TABLE_PROCESSING_DATA);
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        text.add("");
        data.add(0);
        if (!this.onlyLeaks) {
            text.add("");
            data.add(0);
        }
        TreeInput output = new TreeInput();
        output.setText(text);
        tableData.getData().addAll(data);
        output.setData(tableData);
        return output;
    }

    private List<TableInput> makeIntervalTableInput(long start, long end) throws InterruptedException, ExecutionException {
        Query newQuery = new Query(start, end, this.onlyLeaks);
        if (newQuery.equals(this.lastPartQuery)) {
            if (this.partDataTask.isDone()) {
                return this.partDataTask.get();
            }
        } else {
            this.lastPartQuery = newQuery;
            if (this.partDataTask != null) {
                this.partDataTask.cancel(true);
            }
            this.partDataTask = CompletableFuture.supplyAsync(() -> HeapDataProcessor.getInstance().getTableInputPersistentAllocsData(newQuery));
            this.partDataTask.thenRun(() -> Display.getDefault().asyncExec(this::updateTable));
        }
        return this.processingStub;
    }

    private List<TableInput> makeFullTableInput() throws InterruptedException, ExecutionException {
        if (DAState.isDone()) {
            if (this.wholeDataTask == null) {
                this.wholeDataTask = CompletableFuture.supplyAsync(() -> HeapDataProcessor.getInstance().getTableInputPersistentAllocsData(new Query(0L, 0L, this.onlyLeaks)));
                this.wholeDataTask.thenRun(() -> Display.getDefault().asyncExec(this::updateTable));
            }
            if (this.wholeDataTask.isDone()) {
                return this.wholeDataTask.get();
            }
            return this.processingStub;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<TableInput> makeTableInput() {
        if (Global.getProject() == null) {
            return Collections.emptyList();
        }
        try {
            if (IntervalManager.INSTANCE.isIntervalSelected()) {
                long start = (long)(IntervalManager.INSTANCE.getSelectionMarker().getStartVal() * 1000000.0);
                long end = (long)(IntervalManager.INSTANCE.getSelectionMarker().getEndVal() * 1000000.0);
                return this.makeIntervalTableInput(start, end);
            }
            return this.makeFullTableInput();
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    public void removeSelection() {
        this.table.removeAll();
    }

    @Override
    public void clear() {
        this.table.removeAll();
        this.getSelectionIndex().clear();
        this.getSelections().clear();
        this.wholeDataTask = null;
        this.lastPartQuery = null;
        this.partDataTask = null;
    }

    public void cleanColumnsWeights() {
        this.columnWeights = null;
    }
}

