/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.swap.logparser.LogPackage;
import org.tizen.dynamicanalyzer.swap.logparser.Logs;
import org.tizen.dynamicanalyzer.swap.logparser.PageDataManager;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.ui.opengl.GLUtil;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLAPIDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLBufferSizeDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLCommonStateDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLFrameRateDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLFrameTimeDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLRedundantDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLStateHistoryDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLStateProgramDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLStateSharingDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.DB.GLStateTextureDBTableManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLStateDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLStatisticsDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLAPIData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLCurrentFrameDataManger;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLES20ErrorDefine;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLFrameRateInfo;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSharingContextType;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;

public class GLDataManager
extends PageDataManager {
    private static GLDataManager instance = new GLDataManager();
    private GLStateDataManager stateDataManager = null;
    private GLStatisticsDataManager statisticsDataManger = null;
    private List<GLFrameRateInfo> frameRateDataList = null;
    private List<GLSharingContextType> sharingContextList = null;
    private int startFrameRateTime = 1;
    private long selectedContextID = -1L;
    protected int currentFrameIndex = 1;
    private boolean isSelectFrameRateChart = true;
    private long apiTimeOfPreFrameIndex = 0L;
    private String selectedAPIAtTable = "";
    private List<GLAPIData> currentAPITableData = null;
    private int chartSelectedStartIndexForAPITable = -1;
    private int chartSelectedEndIndexForAPITable = -1;
    private GLAPIDBTableManager apiDBTable = new GLAPIDBTableManager();
    private GLFrameRateDBTableManager frameRateDBTable = new GLFrameRateDBTableManager();
    private GLFrameTimeDBTableManager frameTimeDBTable = new GLFrameTimeDBTableManager();
    private GLCommonStateDBTableManager stateDBTable = new GLCommonStateDBTableManager();
    private GLStateProgramDBTableManager stateProgramDBTable = new GLStateProgramDBTableManager();
    private GLStateHistoryDBTableManager stateHistoryDBTable = new GLStateHistoryDBTableManager();
    private GLStateTextureDBTableManager stateTextureDBTable = new GLStateTextureDBTableManager();
    private GLStateSharingDBTableManager stateSharingDBTable = new GLStateSharingDBTableManager();
    private GLRedundantDBTableManager redundantDBTable = null;
    private GLBufferSizeDBTableManager bufferSizeDBTable = null;

    public static GLDataManager getInstance() {
        return instance;
    }

    protected GLDataManager() {
        this.statisticsDataManger = new GLStatisticsDataManager();
        this.setRedundantDBTable(new GLRedundantDBTableManager());
        this.setBufferSizeDBTable(new GLBufferSizeDBTableManager());
        this.clear();
    }

    public void clear() {
        this.stateDataManager = new GLStateDataManager();
        this.frameRateDataList = new ArrayList<GLFrameRateInfo>();
        this.sharingContextList = new ArrayList<GLSharingContextType>();
        this.statisticsDataManger = new GLStatisticsDataManager();
        this.currentAPITableData = new ArrayList<GLAPIData>();
        this.startFrameRateTime = 1;
        this.selectedContextID = -1L;
        this.currentFrameIndex = 1;
        this.chartSelectedStartIndexForAPITable = -1;
        this.chartSelectedEndIndexForAPITable = -1;
        this.isSelectFrameRateChart = true;
        this.apiTimeOfPreFrameIndex = 0L;
        this.selectedAPIAtTable = "";
    }

    @Override
    public void saveData(Map<String, String> dataMap) {
        if (this.stateDataManager != null) {
            this.stateProgramDBTable.insertProgramData();
            this.stateTextureDBTable.insertTextureData();
            this.statisticsDataManger.insertRedundantData();
        }
    }

    @Override
    public void openData(Map<String, String> dataMap) {
        if (this.stateDataManager != null) {
            this.updateFrameTimeChartEndTimeAtOpen();
            this.stateProgramDBTable.initProgramDataAtOpen();
            this.stateTextureDBTable.initTextureDataAtOpen();
            this.statisticsDataManger.selectRedundantData();
            this.updateSharingContextList();
        }
    }

    @Override
    protected void makeData(LogPackage pack) {
        Logs glesLogs = pack.getLogs(274);
        if (glesLogs != null && glesLogs.getRawLogs().size() != 0) {
            this.makeGLData(glesLogs);
        }
    }

    public void makeGLData(Logs glesLogs) {
        this.addAPIDBData(glesLogs);
        this.addAPIStatisticsData(glesLogs);
        this.addFrameTimeChartDBData(glesLogs);
        this.addFrameRateChartDBData(glesLogs);
        this.addStateDBData(glesLogs);
        this.addFailedAPIData(glesLogs);
        this.updateCurrentFrameIndex(glesLogs);
    }

    private void updateCurrentFrameIndex(Logs glesLogs) {
        for (LogData data : glesLogs.getRawLogs()) {
            GLES20LogData logData = (GLES20LogData)data;
            if (!GLUtil.isLastAPIOfFrame(logData.getApiName())) continue;
            ++this.currentFrameIndex;
        }
    }

    private void addFailedAPIData(Logs glesLogs) {
        for (LogData data : glesLogs.getRawLogs()) {
            GLES20LogData logData = (GLES20LogData)data;
            if (!this.checkFailedAPI(logData)) continue;
            SummaryDataManager.getInstance().getFailedApiDataMaker().makeData(logData);
        }
    }

    private void addStateDBData(Logs glesLogs) {
        int currentFrameIndexOfState = this.currentFrameIndex;
        for (LogData data : glesLogs.getRawLogs()) {
            GLES20LogData logData = (GLES20LogData)data;
            this.stateDataManager.extractGLAPIParameter(logData, currentFrameIndexOfState);
            if (!GLUtil.isLastAPIOfFrame(logData.getApiName())) continue;
            ++currentFrameIndexOfState;
        }
    }

    private void addAPIDBData(Logs glesLogs) {
        int currentFrameIndexOfAPI = this.currentFrameIndex;
        ArrayList<GLAPIData> insetAPIDataList = new ArrayList<GLAPIData>();
        for (LogData data : glesLogs.getRawLogs()) {
            GLES20LogData logData = (GLES20LogData)data;
            insetAPIDataList.add(new GLAPIData(logData, currentFrameIndexOfAPI));
            if (!GLUtil.isLastAPIOfFrame(logData.getApiName())) continue;
            ++currentFrameIndexOfAPI;
        }
        this.apiDBTable.insert(insetAPIDataList);
    }

    private void addAPIStatisticsData(Logs glesLogs) {
        for (LogData data : glesLogs.getRawLogs()) {
            this.statisticsDataManger.addAPI((GLES20LogData)data);
        }
    }

    private void addFrameTimeChartDBData(Logs glesLogs) {
        int currentFrameIndexOfFrameTime = this.currentFrameIndex;
        ArrayList<List<Object>> insetFrameTimeChartDataList = new ArrayList<List<Object>>();
        GLCurrentFrameDataManger currentFrameData = new GLCurrentFrameDataManger();
        for (LogData data : glesLogs.getRawLogs()) {
            GLES20LogData logData = (GLES20LogData)data;
            currentFrameData.addAPIData(new GLAPIData(logData, currentFrameIndexOfFrameTime));
            if (!GLUtil.isLastAPIOfFrame(logData.getApiName())) continue;
            this.makeFrameTimeData(insetFrameTimeChartDataList, currentFrameData, currentFrameIndexOfFrameTime, this.apiTimeOfPreFrameIndex, logData.getTime());
            ++currentFrameIndexOfFrameTime;
            this.apiTimeOfPreFrameIndex = logData.getTime();
        }
        this.frameTimeDBTable.insertData(insetFrameTimeChartDataList);
    }

    private void addFrameRateChartDBData(Logs glesLogs) {
        int currentFrameIndexOfFrameRate = this.currentFrameIndex;
        boolean hasFailedAPIofCurrentFrame = false;
        for (LogData data : glesLogs.getRawLogs()) {
            GLES20LogData logData = (GLES20LogData)data;
            if (this.checkFailedAPI(logData)) {
                hasFailedAPIofCurrentFrame = true;
            }
            if (!GLUtil.isLastAPIOfFrame(logData.getApiName())) continue;
            this.makeFrameRateChartDataList(logData, currentFrameIndexOfFrameRate, hasFailedAPIofCurrentFrame);
            hasFailedAPIofCurrentFrame = false;
            ++currentFrameIndexOfFrameRate;
        }
        this.insertTraceFrameChartData((GLES20LogData)glesLogs.getRawLogs().get(glesLogs.getRawLogs().size() - 1));
    }

    private boolean checkFailedAPI(GLES20LogData logData) {
        return logData.getErrno() != GLES20ErrorDefine.EGL_SUCCESS && logData.getErrno() != GLES20ErrorDefine.GL_SUCCESS;
    }

    private void makeFrameRateChartDataList(GLES20LogData logData, int currentFrameIndexOfFrameRate, boolean hasFailedAPIofCurrentFrame) {
        int time = GLUtil.getTimeLineTime(logData);
        for (GLFrameRateInfo data : this.frameRateDataList) {
            if (data.getTime() != time) continue;
            data.addFrameCount();
            return;
        }
        GLFrameRateInfo frameRateData = new GLFrameRateInfo();
        frameRateData.setTime(GLUtil.getTimeLineTime(logData));
        frameRateData.setStartFrameIndex(currentFrameIndexOfFrameRate);
        frameRateData.setErrno(hasFailedAPIofCurrentFrame);
        frameRateData.setPid(logData.getPid());
        frameRateData.addFrameCount();
        this.frameRateDataList.add(frameRateData);
    }

    private void insertTraceFrameChartData(GLES20LogData lastLog) {
        ArrayList<List<Object>> insetData = new ArrayList<List<Object>>();
        ArrayList<GLFrameRateInfo> removeframeInfoList = new ArrayList<GLFrameRateInfo>();
        for (GLFrameRateInfo data : this.frameRateDataList) {
            if (GLUtil.getTimeLineTime(lastLog) <= data.getTime()) continue;
            ArrayList<Constable> framRateChartData = new ArrayList<Constable>();
            framRateChartData.add(Integer.valueOf(data.getTime()));
            framRateChartData.add(Integer.valueOf(data.getFrameCount() - 1));
            framRateChartData.add(Integer.valueOf(data.getStartFrameIndex()));
            framRateChartData.add(Boolean.valueOf(data.hasErrno()));
            framRateChartData.add(Integer.valueOf(data.getPid()));
            insetData.add(framRateChartData);
            removeframeInfoList.add(data);
        }
        this.frameRateDataList.removeAll(removeframeInfoList);
        if (insetData.size() > 0) {
            this.frameRateDBTable.insert(insetData);
        }
    }

    private void makeFrameTimeData(List<List<Object>> insetFrameTimeChartDataList, GLCurrentFrameDataManger glCurrentFrameData, int currentFrameIndexOfFrameTime, long apiTimeOfPreFrameIndex, long apiTime) {
        long frameValue = (apiTime - apiTimeOfPreFrameIndex) / 1000L;
        ArrayList<Constable> framTimeChartData = new ArrayList<Constable>();
        framTimeChartData.add(Integer.valueOf(currentFrameIndexOfFrameTime));
        framTimeChartData.add(Integer.valueOf(GLUtil.getTimeLineTime(glCurrentFrameData.getFirstLogData())));
        framTimeChartData.add(Integer.valueOf((int)frameValue));
        framTimeChartData.add(Boolean.valueOf(glCurrentFrameData.hasError()));
        framTimeChartData.add(Integer.valueOf(glCurrentFrameData.getPid()));
        glCurrentFrameData.initFrameIndex();
        insetFrameTimeChartDataList.add(framTimeChartData);
    }

    public void updateSharingContextList() {
        this.sharingContextList = GLDataManager.getInstance().getStateSharingDBTableManage().selectSharingData();
    }

    public boolean isSharingData(long itemContextId) {
        if (this.sharingContextList == null) {
            return false;
        }
        int i = 0;
        while (i < this.sharingContextList.size()) {
            long contextId = this.sharingContextList.get(i).getContextId();
            long sharingContextId = this.sharingContextList.get(i).getSharingContextId();
            if (contextId == this.selectedContextID && sharingContextId == itemContextId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getFrameSize() {
        return this.currentFrameIndex;
    }

    private void updateFrameTimeChartEndTimeAtOpen() {
        this.currentFrameIndex = this.frameTimeDBTable.getFrameSize();
    }

    public GLFrameRateInfo getFrameRateStartIndex(int startIndex, int endIndex) {
        return this.frameRateDBTable.selectFrameCountInfo(startIndex, endIndex);
    }

    public long getSelectedContextID() {
        return this.selectedContextID;
    }

    public void setSelectedContextID(long selectedContextID) {
        this.selectedContextID = selectedContextID;
    }

    public List<GLAPIData> getCurrentAPITableData(int frameStartIndex, int frameEndIndex, List<String> whereClause) {
        this.chartSelectedStartIndexForAPITable = frameStartIndex;
        this.chartSelectedEndIndexForAPITable = frameEndIndex;
        this.currentAPITableData = this.getAPIDataMagerInstance().selectOpenGLAPIData(frameStartIndex, frameEndIndex, whereClause);
        return this.currentAPITableData;
    }

    public List<GLAPIData> getCurrentAPITableData() {
        return this.currentAPITableData;
    }

    public GLAPIDBTableManager getAPIDataMagerInstance() {
        return this.apiDBTable;
    }

    public GLStateDataManager getStateDataManager() {
        return this.stateDataManager;
    }

    public GLFrameRateDBTableManager getFrameRateDBTableManager() {
        return this.frameRateDBTable;
    }

    public GLFrameTimeDBTableManager getFrameTimeDBTableManager() {
        return this.frameTimeDBTable;
    }

    public GLCommonStateDBTableManager getContextDBTableManage() {
        return this.stateDBTable;
    }

    public GLStateProgramDBTableManager getStateProgramDBTableManage() {
        return this.stateProgramDBTable;
    }

    public GLStateHistoryDBTableManager getStateHistoryDBTableManage() {
        return this.stateHistoryDBTable;
    }

    public GLStateTextureDBTableManager getStateTextureDBTableManage() {
        return this.stateTextureDBTable;
    }

    public GLStateSharingDBTableManager getStateSharingDBTableManage() {
        return this.stateSharingDBTable;
    }

    public GLStatisticsDataManager getStatisticsDataManger() {
        return this.statisticsDataManger;
    }

    public boolean isSelectFrameRateChart() {
        return this.isSelectFrameRateChart;
    }

    public void setSelectFrameRateChart(boolean isShowFrameRateChart) {
        this.isSelectFrameRateChart = isShowFrameRateChart;
    }

    public int getStartFrameRateTime() {
        return this.startFrameRateTime;
    }

    public void setStartFrameRateTime(int startFrameRateTime) {
        this.startFrameRateTime = startFrameRateTime;
    }

    public String getSelectedAPIAtTable() {
        return this.selectedAPIAtTable;
    }

    public void setSelectedAPIAtTable(String selectedAPIAtTable) {
        this.selectedAPIAtTable = selectedAPIAtTable;
    }

    public GLRedundantDBTableManager getRedundantDBTable() {
        return this.redundantDBTable;
    }

    public void setRedundantDBTable(GLRedundantDBTableManager redundantDBTable) {
        this.redundantDBTable = redundantDBTable;
    }

    public GLBufferSizeDBTableManager getBufferSizeDBTable() {
        return this.bufferSizeDBTable;
    }

    public void setBufferSizeDBTable(GLBufferSizeDBTableManager bufferSizeDBTable) {
        this.bufferSizeDBTable = bufferSizeDBTable;
    }
}

