/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.ChartPopupMenu;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.chart.SyncChart;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncDataEvent;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.ui.widgets.DADefaultChartBoard;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class SyncChartBoard
extends DADefaultChartBoard {
    private List<SyncChart> syncChartItemList = new ArrayList<SyncChart>();
    protected int syncListCount = -1;
    private int preSelectionPId = -1;

    public SyncChartBoard(Composite parent, String title) {
        super(parent, title);
    }

    public SyncChartBoard(Composite parent, String title, int[] scaleValues) {
        super(parent, title, scaleValues);
    }

    public SyncChartBoard(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    protected void callBackScaleChanged() {
        super.callBackScaleChanged();
        this.updateChart();
    }

    protected void callBackScrollChanged() {
        super.callBackScrollChanged();
        this.updateChart();
    }

    protected void callBackSizeChanged() {
        this.layout(true, true);
        super.callBackSizeChanged();
    }

    public void updateChart() {
        this.createChartItem();
        this.clearSeries();
        this.updateSeries();
        this.chartFilteringByPId();
    }

    protected void chartFilteringByPId() {
        if (this.getItemList() == null) {
            return;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPId == selectedPid) {
            return;
        }
        int parentIndex = 0;
        for (SyncChart chart : this.syncChartItemList) {
            if (chart.getChartType() == 1) continue;
            if (selectedPid == 0) {
                this.showItem(parentIndex);
            } else if (selectedPid == chart.getpId()) {
                this.showItem(parentIndex);
            } else {
                this.hideItem(parentIndex);
            }
            ++parentIndex;
        }
        this.preSelectionPId = selectedPid;
    }

    public void clear() {
        super.clear();
        this.syncChartItemList.clear();
        this.syncListCount = -1;
        this.preSelectionPId = -1;
    }

    protected void initChart(DAChart chart, boolean isParent) {
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        if (isParent) {
            plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        } else {
            plot.setBackgroundImage(ImageResources.BG_CHILD_GRADIENT);
        }
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
        plot.setAxisRangeY(0.0, 101.0);
        plot.setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        ChartPopupMenu popupMenu = new ChartPopupMenu(chart);
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        TimelineChartMouseEventListener timelineChartMouseEventListener = new TimelineChartMouseEventListener(popupMenu, this.getTimeline(), ThreadPage.pageID);
        chart.addMouseListener((MouseListener)timelineChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)timelineChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
        TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
        chart.addKeyListener((KeyListener)timelineKeyListener);
    }

    public boolean createChartItem() {
        if (this.syncListCount != ThreadDataManager.getInstance().getSyncDataMaker().getChartRowData().size()) {
            List<SyncChart> tempSyncChartItemList = this.syncChartItemList;
            this.syncChartItemList = new ArrayList<SyncChart>();
            for (ThreadPageSyncData data : ThreadDataManager.getInstance().getSyncDataMaker().getSyncParentChartRowData()) {
                this.createSyncChartItem(tempSyncChartItemList, data);
                List<ThreadPageSyncData> sortList = this.sortSyncChartByTID(data.getChildren());
                for (ThreadPageSyncData childData : sortList) {
                    this.createSyncChartItem(tempSyncChartItemList, childData);
                }
            }
            tempSyncChartItemList.clear();
        }
        this.syncListCount = ThreadDataManager.getInstance().getSyncDataMaker().getChartRowData().size();
        return true;
    }

    private List<ThreadPageSyncData> sortSyncChartByTID(List<ThreadPageSyncData> list) {
        Comparator<ThreadPageSyncData> comparator = new Comparator<ThreadPageSyncData>(){

            @Override
            public int compare(ThreadPageSyncData arg0, ThreadPageSyncData arg1) {
                if (arg0.getTid() > arg1.getTid()) {
                    return 1;
                }
                if (arg0.getTid() < arg1.getTid()) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        return list;
    }

    private void createSyncChartItem(List<SyncChart> charItemList, ThreadPageSyncData data) {
        SyncChart item = null;
        for (SyncChart chart : charItemList) {
            if (chart.getChartID() != data.getSyncDataID()) continue;
            item = chart;
            break;
        }
        if (item == null) {
            if (data.getSyncDataType() == 0) {
                this.addSyncParentChartItemList(data);
            } else {
                this.addChartChildItemList(data);
            }
        } else {
            this.syncChartItemList.add(item);
        }
    }

    protected boolean isExistSyncChartRow(ThreadPageSyncData data) {
        for (SyncChart chart : this.syncChartItemList) {
            if (chart.getChartID() != data.getSyncDataID()) continue;
            return true;
        }
        return false;
    }

    private void addChartChildItemList(ThreadPageSyncData data) {
        SyncChart parent = this.getParentChartData(data);
        if (parent != null) {
            this.addSyncChildChartItemList(parent, data);
        }
    }

    private void addSyncParentChartItemList(ThreadPageSyncData sync) {
        DAChartBoardItem parentItem = new DAChartBoardItem((DAChartBoard)this, String.valueOf(sync.getTypeString()) + ThreadPageLabels.THREAD_CHART_NAME_PREFIX + ThreadPageLabels.THREAD_CHART_NAME_OBJ + AnalyzerUtil.toHexdecimal(sync.getKey()) + ThreadPageLabels.THREAD_CHART_NAME_POSTFIX);
        parentItem.setData((Object)sync);
        DAChart parentDAChart = parentItem.getChart();
        this.initChart(parentDAChart, true);
        SyncChart parentChartData = new SyncChart(sync.getSyncDataID(), parentItem, parentDAChart, 0);
        parentChartData.setpId(Integer.parseInt(sync.getPid()));
        this.syncChartItemList.add(parentChartData);
    }

    protected void addSyncChildChartItemList(SyncChart parent, ThreadPageSyncData sync) {
        DAChartBoardItem parentItem = parent.getItem();
        DAChartBoardItem childItem = null;
        if (sync.getSyncDataType() == 2) {
            childItem = new DAChartBoardItem(parentItem, String.valueOf(sync.getTypeString()) + ThreadPageLabels.THREAD_CHART_NAME_PREFIX + ThreadPageLabels.THREAD_CHART_NAME_OBJ + AnalyzerUtil.toHexdecimal(sync.getKey()) + ThreadPageLabels.THREAD_CHART_NAME_POSTFIX);
        } else if (sync.getSyncDataType() == 1) {
            childItem = new DAChartBoardItem(parentItem, String.valueOf(ThreadPageLabels.THREAD_CHART_NAME_TID) + sync.getTid());
        } else {
            Logger.error((Object)"Never goes here!");
            return;
        }
        childItem.setData((Object)sync);
        DAChart childChart = childItem.getChart();
        childChart.setData((Object)parent.gettId());
        this.initChart(childChart, false);
        SyncChart childChartData = new SyncChart(sync.getSyncDataID(), childItem, childChart, 1);
        parent.pushChild(childChartData);
        this.syncChartItemList.add(childChartData);
    }

    private SyncChart getParentChartData(ThreadPageSyncData syncData) {
        if (syncData.getSyncDataType() != 1) {
            return null;
        }
        for (SyncChart chart : this.syncChartItemList) {
            if (chart.getChartID() != syncData.getParentID()) continue;
            return chart;
        }
        return null;
    }

    public void clearSeries() {
        this.clearSyncSeries();
    }

    private void clearSyncSeries() {
        if (this.syncChartItemList == null) {
            return;
        }
        for (SyncChart chart : this.syncChartItemList) {
            chart.clearSeries();
        }
    }

    private void updateSeries() {
        this.updateSyncEventSeries();
    }

    protected void updateSyncEventSeries() {
        if (this.syncChartItemList == null) {
            return;
        }
        List<ThreadPageSyncDataEvent> seriesList = this.getSyncEventList();
        if (seriesList == null) {
            return;
        }
        for (SyncChart chart : this.syncChartItemList) {
            chart.updateSyncSeries(seriesList);
        }
    }

    private List<ThreadPageSyncDataEvent> getSyncEventList() {
        ArrayList<ThreadPageSyncDataEvent> returnList = new ArrayList<ThreadPageSyncDataEvent>();
        returnList.addAll(this.selectSyncEventFromDB());
        returnList.addAll(ThreadDataManager.getInstance().getSyncDataMaker().getNotInsertSyncEventList());
        return returnList;
    }

    /*
     * Exception decompiling
     */
    private List<ThreadPageSyncDataEvent> selectSyncEventFromDB() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<SyncChart> getSyncChartList() {
        return this.syncChartItemList;
    }
}

