/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.SymbolManager;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.ThreadData;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningCase;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadDataEvent;
import org.tizen.dynamicanalyzer.util.Logger;

public class ThreadThreadDataMaker {
    private List<ThreadPageThreadDataEvent> eventQueue = new ArrayList<ThreadPageThreadDataEvent>();
    private HashMap<String, Integer> joinableThreadMap = new HashMap();
    private List<ThreadPageThreadData> chartRowData = new ArrayList<ThreadPageThreadData>();
    private HashMap<String, Long> threadFuncMap = new HashMap();
    private HashMap<String, Integer> attrMap = new HashMap();
    private HashMap<String, Integer> threadAttrMap = new HashMap();
    private List<ThreadPageThreadDataEvent> callEventQueue = new ArrayList<ThreadPageThreadDataEvent>();
    public static final String HEX_NULL = "0x0";
    public static final int PTHREAD_CREATE_JOINABLE = 0;
    public static final int PTHREAD_CREATE_DETACHED = 1;

    public void makeThreadData(List<LogData> threadInputs) {
        int logSize = threadInputs.size();
        int i = 0;
        while (i < logSize) {
            this.parseAPI(threadInputs.get(i));
            ++i;
        }
        int size = this.eventQueue.size();
        if (size == 0) {
            return;
        }
        ArrayList<ThreadPageThreadDataEvent> insertThreadEvent = new ArrayList<ThreadPageThreadDataEvent>();
        for (ThreadPageThreadDataEvent event : this.eventQueue) {
            if (!this.checkPairEvent(event)) continue;
            event.setThreadDataID(this.getThreadDataID(event.getTid()));
            insertThreadEvent.add(event);
        }
        this.eventQueue.removeAll(insertThreadEvent);
        ThreadDataManager.getInstance().insertThreadEventData(insertThreadEvent, true);
        ThreadDataManager.getInstance().insertThreadAPIData(insertThreadEvent, true);
    }

    public void parseAPI(LogData input) {
        if (input == null) {
            return;
        }
        if (!(input instanceof ThreadData)) {
            return;
        }
        ThreadData log = (ThreadData)input;
        int threadType = log.getThreadType();
        switch (threadType) {
            case 0: {
                this.parsePthread(log);
                break;
            }
            case 1: {
                break;
            }
            default: {
                Logger.error((Object)"thread page err: unknown thread type");
            }
        }
    }

    private void parsePthread(ThreadData input) {
        long time = input.getTime();
        String pid = Integer.toString(input.getPid());
        int apiType = input.getApiType();
        String apiName = input.getApiName();
        long errorNum = input.getErrno();
        int tID = input.getTid();
        String pthreadId = Long.toString(input.getPThreadId());
        if (errorNum != 0L) {
            SummaryDataManager.getInstance().getFailedApiDataMaker().makeData(input);
        }
        switch (apiType) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                if (apiName.equals(ThreadPageLabels.THREAD_API_PTHREAD_ATTR_INIT)) {
                    this.attrMap.put(input.getArgs(), 0);
                } else if (apiName.equals(ThreadPageLabels.THREAD_API_PTHREAD_ATTR_DESTROY)) {
                    this.attrMap.remove(input.getArgs());
                } else if (apiName.equals(ThreadPageLabels.THREAD_API_PTHREAD_ATTR_SETDETACHSTATE)) {
                    this.checkThreadAttrType(input.getArgs());
                } else if (apiName.equals(ThreadPageLabels.THREAD_API_PTHREAD_DETACH)) {
                    Integer threadAttrTypeInt = this.threadAttrMap.get(pthreadId);
                    if (threadAttrTypeInt != null && threadAttrTypeInt == 0) {
                        this.threadAttrMap.put(pthreadId, 1);
                        ThreadPageThreadData threadData = this.findParentDataOfThread(tID);
                        if (threadData != null && threadData.getType() == 1) {
                            threadData.setAttrType(ThreadPageLabels.THREAD_ATTR_TYPE_DETACHED);
                        }
                    }
                    this.joinableThreadMap.remove(pthreadId);
                }
                ThreadPageThreadDataEvent event = new ThreadPageThreadDataEvent(0, 0, apiType, time, tID, apiName, errorNum, input);
                this.eventQueue.add(event);
                break;
            }
            case 1: {
                if (apiName.equals(ThreadPageLabels.THREAD_API_PTHREAD_CREATE)) {
                    this.checkThreadType(input.getArgs(), pthreadId);
                    this.checkThreadFunc(input.getArgs(), pthreadId);
                }
                ThreadPageThreadDataEvent event = new ThreadPageThreadDataEvent(0, 0, apiType, time, tID, apiName, errorNum, input);
                event.setCallID(pthreadId);
                this.callEventQueue.add(event);
                break;
            }
            case 5: {
                ThreadPageThreadDataEvent event = new ThreadPageThreadDataEvent(1, 0, apiType, time, tID, apiName, errorNum, input);
                this.eventQueue.add(event);
                Integer joinTID = this.joinableThreadMap.get(pthreadId);
                if (joinTID == null || !input.getApiName().equals(ThreadPageLabels.THREAD_API_PTHREAD_JOIN)) break;
                SummaryDataManager.getInstance().getWarningDataMaker().removeData(event.getContents(), String.valueOf(ThreadPageLabels.THREAD_CHART_NAME_TID) + this.findCallerTid(pthreadId), WarningCase.JOINABLE_LEAK.getType());
                this.joinableThreadMap.remove(pthreadId);
                break;
            }
            case 7: {
                ThreadPageThreadDataEvent event = new ThreadPageThreadDataEvent(1, 0, apiType, time, tID, ThreadPageLabels.THREAD_CHART_ITEM_EXITED, errorNum, input);
                event.setCallID(pthreadId);
                event.setThreadDataID(this.getThreadDataID(event.getTid()));
                Integer joinTID = this.joinableThreadMap.get(pthreadId);
                if (joinTID != null && joinTID == tID) {
                    SummaryDataManager.getInstance().getWarningDataMaker().add(input, String.valueOf(ThreadPageLabels.THREAD_CHART_NAME_TID) + tID, WarningCase.JOINABLE_LEAK.getType());
                }
                this.setEndTime(tID, time);
                Integer threadAttrTypeInt = this.threadAttrMap.get(pthreadId);
                if (threadAttrTypeInt != null && threadAttrTypeInt == 0) {
                    this.callEventQueue.add(event);
                } else {
                    ArrayList<ThreadPageThreadDataEvent> insertThreadEvent = new ArrayList<ThreadPageThreadDataEvent>();
                    insertThreadEvent.add(event);
                    ThreadDataManager.getInstance().insertThreadEventData(insertThreadEvent, true);
                    ThreadDataManager.getInstance().insertThreadAPIData(insertThreadEvent, true);
                }
                this.threadAttrMap.remove(pthreadId);
                break;
            }
            case 6: {
                Integer threadAttrTypeInt = this.threadAttrMap.get(pthreadId);
                String threadAttrType = threadAttrTypeInt != null ? ThreadThreadDataMaker.getAttrTypeByTypeInt(threadAttrTypeInt) : ThreadPageLabels.THREAD_ATTR_TYPE_JOINABLE;
                if (threadAttrType.equals(ThreadPageLabels.THREAD_ATTR_TYPE_JOINABLE)) {
                    this.joinableThreadMap.put(pthreadId, tID);
                }
                int funcID = SymbolManager.getFuncId(null, this.threadFuncMap.get(pthreadId), input.getPid(), input.getTime());
                ThreadPageThreadData data = new ThreadPageThreadData(1, pid, tID, threadAttrType, funcID);
                data.setStartTime(time);
                this.chartRowData.add(data);
                ThreadPageThreadDataEvent event = new ThreadPageThreadDataEvent(1, 0, apiType, time, tID, ThreadPageLabels.THREAD_CHART_ITEM_CREATED, errorNum, input);
                this.eventQueue.add(event);
                ArrayList<ThreadPageThreadDataEvent> insertThreadEvent = new ArrayList<ThreadPageThreadDataEvent>();
                int i = 0;
                while (i < this.callEventQueue.size()) {
                    ThreadPageThreadDataEvent callEvent = this.callEventQueue.get(i);
                    if (callEvent.getCallID().equals(pthreadId) && callEvent.getApiType() == 7) {
                        callEvent.setThreadDataID(this.getThreadDataID(callEvent.getTid()));
                        insertThreadEvent.add(callEvent);
                    }
                    ++i;
                }
                this.callEventQueue.removeAll(insertThreadEvent);
                ThreadDataManager.getInstance().insertThreadEventData(insertThreadEvent, true);
                ThreadDataManager.getInstance().insertThreadAPIData(insertThreadEvent, true);
                break;
            }
            default: {
                Logger.error((Object)"thread page err: unknown thread api type");
            }
        }
    }

    public void insertRemainingCallEvent() {
        ArrayList<ThreadPageThreadDataEvent> insertThreadEvent = new ArrayList<ThreadPageThreadDataEvent>();
        int i = 0;
        while (i < this.callEventQueue.size()) {
            ThreadPageThreadDataEvent callEvent = this.callEventQueue.get(i);
            callEvent.setThreadDataID(this.getThreadDataID(callEvent.getTid()));
            insertThreadEvent.add(callEvent);
            ++i;
        }
        ThreadDataManager.getInstance().insertThreadEventData(insertThreadEvent, true);
        ThreadDataManager.getInstance().insertThreadAPIData(insertThreadEvent, true);
        this.callEventQueue.clear();
    }

    public List<ThreadPageThreadDataEvent> getRemainingCallEvent() {
        return this.callEventQueue;
    }

    private boolean checkPairEvent(ThreadPageThreadDataEvent event) {
        if (event.getEventType() != 1) {
            return true;
        }
        int apiType = event.getApiType();
        int threadType = event.getThreadType();
        ThreadData tData = (ThreadData)event.getContents();
        if (6 == apiType) {
            int callEventQueueSize = this.callEventQueue.size();
            int i = 0;
            while (i < callEventQueueSize) {
                ThreadPageThreadDataEvent callEvent = this.callEventQueue.get(i);
                if (callEvent.getApiType() == 1 && callEvent.getThreadType() == threadType) {
                    if (threadType == 1) {
                        String callerTizenID = callEvent.getCallID();
                        String eventTizenID = Long.toString(tData.getOspThreadId());
                        if (eventTizenID.equals(callerTizenID)) {
                            event.setCallerTid(callEvent.getTid());
                            this.callEventQueue.remove(i);
                            return true;
                        }
                    } else {
                        String callerPthreadID = callEvent.getCallID();
                        String eventPthreadID = Long.toString(tData.getPThreadId());
                        if (eventPthreadID.equals(callerPthreadID)) {
                            event.setCallerTid(callEvent.getTid());
                            this.callEventQueue.remove(i);
                            callEvent.setThreadDataID(this.getThreadDataID(callEvent.getTid()));
                            ArrayList<ThreadPageThreadDataEvent> insertThreadEvent = new ArrayList<ThreadPageThreadDataEvent>();
                            insertThreadEvent.add(callEvent);
                            ThreadDataManager.getInstance().insertThreadEventData(insertThreadEvent, true);
                            ThreadDataManager.getInstance().insertThreadAPIData(insertThreadEvent, true);
                            this.setCreateTIDToThreadData(event);
                            return true;
                        }
                    }
                }
                ++i;
            }
            return false;
        }
        if (5 == apiType) {
            if (!event.isJoinAPI()) {
                return true;
            }
            int callEventQueueSize = this.callEventQueue.size();
            int i = 0;
            while (i < callEventQueueSize) {
                ThreadPageThreadDataEvent callEvent = this.callEventQueue.get(i);
                if (callEvent.getApiType() == 7 && callEvent.getThreadType() == threadType) {
                    if (threadType == 1) {
                        String callerTizenID = callEvent.getCallID();
                        String eventTizenID = Long.toString(tData.getOspThreadId());
                        if (eventTizenID.equals(callerTizenID)) {
                            event.setCallerTid(callEvent.getTid());
                            callEvent.setCallerTid(event.getTid());
                            SummaryDataManager.getInstance().getWarningDataMaker().removeData(event.getContents(), String.valueOf(ThreadPageLabels.THREAD_CHART_NAME_TID) + callEvent.getTid(), WarningCase.JOINABLE_LEAK.getType());
                            this.callEventQueue.remove(i);
                            return true;
                        }
                    } else {
                        String callerPthreadID = callEvent.getCallID();
                        String eventPthreadID = Long.toString(tData.getPThreadId());
                        if (eventPthreadID.equals(callerPthreadID)) {
                            event.setCallerTid(callEvent.getTid());
                            callEvent.setCallerTid(event.getTid());
                            this.callEventQueue.remove(i);
                            callEvent.setThreadDataID(this.getThreadDataID(callEvent.getTid()));
                            ArrayList<ThreadPageThreadDataEvent> insertThreadEvent = new ArrayList<ThreadPageThreadDataEvent>();
                            insertThreadEvent.add(callEvent);
                            ThreadDataManager.getInstance().insertThreadEventData(insertThreadEvent, true);
                            ThreadDataManager.getInstance().insertThreadAPIData(insertThreadEvent, true);
                            this.setJoinTIDToThreadData(callEvent);
                            return true;
                        }
                    }
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private int findCallerTid(String id) {
        int callEventQueueSize = this.callEventQueue.size();
        int i = 0;
        while (i < callEventQueueSize) {
            String callerTID;
            ThreadPageThreadDataEvent callEvent = this.callEventQueue.get(i);
            if (callEvent.getApiType() == 7 && (callerTID = callEvent.getCallID()) != null && callerTID.equals(id)) {
                return callEvent.getTid();
            }
            ++i;
        }
        return -1;
    }

    public void setChartRowData(ThreadPageThreadData data) {
        this.chartRowData.add(data);
    }

    public List<ThreadPageThreadData> getChartRowData() {
        ArrayList<ThreadPageThreadData> returnList = new ArrayList<ThreadPageThreadData>();
        for (ThreadPageThreadData data : this.chartRowData) {
            returnList.add(data);
        }
        return returnList;
    }

    private void setEndTime(int tID, long endTime) {
        for (ThreadPageThreadData threadData : this.chartRowData) {
            if (threadData.getTid() != tID) continue;
            threadData.setEndTime(endTime);
        }
    }

    public int getThreadDataID(int tID) {
        for (ThreadPageThreadData threadData : this.chartRowData) {
            if (threadData.getTid() != tID) continue;
            return threadData.getThreadDataID();
        }
        return 0;
    }

    public void createMainThreadItem(int tid) {
        int funcID = Global.getFunctionID("main");
        ThreadPageThreadData mainData = new ThreadPageThreadData(0, Integer.toString(tid), tid, "", funcID);
        this.chartRowData.add(mainData);
    }

    public static String getAttrTypeByTypeInt(int typeInt) {
        if (typeInt == 0) {
            return ThreadPageLabels.THREAD_ATTR_TYPE_JOINABLE;
        }
        if (typeInt == 1) {
            return ThreadPageLabels.THREAD_ATTR_TYPE_DETACHED;
        }
        return "";
    }

    private void checkThreadAttrType(String input) {
        String[] temp = input.split(",");
        if (temp.length != 2) {
            return;
        }
        String obj = temp[0];
        String type = temp[1].trim();
        if (this.attrMap.get(obj) != null) {
            this.attrMap.put(obj, Integer.valueOf(type));
        }
    }

    private void checkThreadType(String args, String pthreadId) {
        String[] temp = args.split(",");
        if (temp.length != 4) {
            return;
        }
        String attrObj = temp[1].trim();
        Integer attrType = 0;
        if (attrObj != null && !attrObj.equals(HEX_NULL)) {
            attrType = this.attrMap.get(attrObj);
        }
        this.threadAttrMap.put(pthreadId, attrType);
    }

    private void checkThreadFunc(String args, String pthreadId) {
        String[] temp = args.split(",");
        if (temp.length != 4) {
            return;
        }
        String strFuncAddr = temp[2].trim();
        Long funcAddr = Long.decode(strFuncAddr);
        this.threadFuncMap.put(pthreadId, funcAddr);
    }

    public ThreadPageThreadData findParentDataOfThread(int tID) {
        for (ThreadPageThreadData threadData : this.chartRowData) {
            if (threadData.getTid() != tID) continue;
            return threadData;
        }
        return null;
    }

    public void setCreateTIDToThreadData(ThreadPageThreadDataEvent event) {
        for (ThreadPageThreadData threadData : this.chartRowData) {
            if (threadData.getTid() != event.getTid() || threadData.getCreateTID() != -1) continue;
            threadData.setCreateTID(event.getCallerTid());
            return;
        }
    }

    public void setJoinTIDToThreadData(ThreadPageThreadDataEvent event) {
        for (ThreadPageThreadData threadData : this.chartRowData) {
            if (threadData.getTid() != event.getTid() || threadData.getJoinTID() != -1) continue;
            threadData.setJoinTID(event.getCallerTid());
            return;
        }
    }

    public void clear() {
        this.callEventQueue.clear();
        this.eventQueue.clear();
        this.joinableThreadMap.clear();
        this.chartRowData.clear();
        this.threadFuncMap.clear();
        this.attrMap.clear();
        this.threadAttrMap.clear();
        ThreadPageThreadData.clear();
    }
}

