/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.calltrace;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionSampleDBTable;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.ProfileDataMaker;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.FunctionEntryDBTable;

public class FunctionProfilingDataUpdater {
    FunctionEntryDBTable updatedFunctionEntryDBTable;
    final int pid;
    FunctionSampleDBTable sampleTable;
    List<List<Object>> samplingDBTableData = new ArrayList<List<Object>>();
    long lowestSamplingTime;
    ProfileDataMaker dataMaker;

    protected FunctionProfilingDataUpdater(FunctionEntryDBTable dbTable, int pid) {
        this.updatedFunctionEntryDBTable = dbTable;
        this.pid = pid;
        this.sampleTable = FunctionUsageProfiler.getInstance().getFunctionSampleTable();
        this.dataMaker = FunctionUsageProfiler.getInstance().getProfileDataMakerByPid(pid);
        this.samplingDBTableData = this.sampleTable.selectAllColumnData(" order by " + FunctionSampleDBTable.COLUMN.SAMPLE_TIME.name + " DESC ");
        this.updateLowestSamplingTime();
    }

    void updateProfilingInfo(long startTime) {
        String where = " where " + FunctionEntryDBTable.COLUMN.START_TIME.name + ">" + startTime + " and " + FunctionEntryDBTable.COLUMN.START_TIME.name + "<=" + (startTime + 200000L) + " order by " + FunctionEntryDBTable.COLUMN.START_TIME.name;
        String samplingWhere = " where " + FunctionSampleDBTable.COLUMN.PID.name + "=" + this.pid + " and " + FunctionSampleDBTable.COLUMN.SAMPLE_TIME.name + ">" + startTime + " and " + FunctionSampleDBTable.COLUMN.SAMPLE_TIME.name + "<=" + (startTime + 200000L) + " order by " + FunctionSampleDBTable.COLUMN.SAMPLE_TIME.name + " DESC ";
        this.samplingDBTableData.addAll(0, this.sampleTable.selectAllColumnData(samplingWhere));
        this.updateLowestSamplingTime();
        for (List<Object> list : this.updatedFunctionEntryDBTable.selectAllColumnData(where)) {
            long time = (Long)list.get(FunctionEntryDBTable.COLUMN.START_TIME.index);
            this.updateRates(time);
            this.dataMaker.finalizeFUPDataForCallTrace(list);
        }
    }

    void updateRates(long time) {
        while (!this.samplingDBTableData.isEmpty() && this.lowestSamplingTime < time) {
            List<Object> dbrecord = this.samplingDBTableData.remove(this.samplingDBTableData.size() - 1);
            this.dataMaker.finalizeFunctionUsageProfileData(dbrecord);
            this.updateLowestSamplingTime();
        }
    }

    private void updateLowestSamplingTime() {
        if (!this.samplingDBTableData.isEmpty()) {
            this.lowestSamplingTime = (Long)this.samplingDBTableData.get(this.samplingDBTableData.size() - 1).get(FunctionSampleDBTable.COLUMN.SAMPLE_TIME.index);
        }
    }
}

