/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.setting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.constant.CommonConstants;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.toolbar.setting.TargetDialog;
import org.tizen.dynamicanalyzer.widgets.button.toggle.DACustomFeatureToggleButton;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;

public class TargetDialogAppListPage
extends DABaseComposite {
    private static final int TextLength = 25;
    private static final int ELLIPSIS_START_POS = 10;
    private static final int DEFAULT_TEXT_Y_POINT = 0;
    private static final int APP_TOGGLE_WIDTH = 254;
    private TargetDialog targetDialog = null;
    private Composite appListParentComp = null;
    private ScrolledComposite appListScrolledComposite = null;
    private Composite appListComp = null;
    private List<DACustomFeatureToggleButton> appToggleList = new ArrayList<DACustomFeatureToggleButton>();
    private Cursor daCursor = null;
    private NavigableMap<String, AppInfo> flatAppMapByID = new TreeMap<String, AppInfo>();
    private Listener toggleUpListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            String appID = toggleButton.getToolTipText();
            if (!toggleButton.isToggled()) {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            } else {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
                for (DACustomFeatureToggleButton other : TargetDialogAppListPage.this.appToggleList) {
                    if (other.getToolTipText().equals(appID) || !other.isToggled()) continue;
                    other.setToggled(false);
                    other.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
                }
            }
            AppInfo appToDraw = (AppInfo)TargetDialogAppListPage.this.flatAppMapByID.get(appID);
            if (appToDraw != null && toggleButton.isToggled()) {
                TargetDialogAppListPage.this.targetDialog.getInfoPage().drawAppInfoPage(appToDraw);
            } else {
                TargetDialogAppListPage.this.targetDialog.getInfoPage().drawAppInfoPage(null);
            }
            TargetDialogAppListPage.this.targetDialog.setOKButtonEnable(toggleButton.isToggled());
        }
    };
    private Listener toggleDownListener = new Listener(){

        public void handleEvent(Event event) {
            DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
            if (toggleButton.isToggled()) {
                toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
            }
        }
    };
    private Listener cursorListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 6 || event.type == 7) {
                DACustomFeatureToggleButton toggleButton = (DACustomFeatureToggleButton)event.widget;
                toggleButton.setFocus();
                if (TargetDialogAppListPage.this.daCursor != null) {
                    TargetDialogAppListPage.this.daCursor.dispose();
                }
                if (event.type == 6) {
                    TargetDialogAppListPage.this.daCursor = new Cursor((Device)TargetDialogAppListPage.this.getShell().getDisplay(), 21);
                } else if (event.type == 7) {
                    TargetDialogAppListPage.this.daCursor = new Cursor((Device)TargetDialogAppListPage.this.getShell().getDisplay(), 0);
                } else {
                    return;
                }
                TargetDialogAppListPage.this.getShell().setCursor(TargetDialogAppListPage.this.daCursor);
            }
        }
    };

    public TargetDialogAppListPage(Composite parent, TargetDialog targetDialog, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.targetDialog = targetDialog;
        this.appListParentComp = parent;
    }

    public void drawAppList(Map<String, PackageInfo> pkgMap) {
        this.appToggleList.clear();
        this.flatAppMapByID.clear();
        if (this.appListScrolledComposite != null) {
            this.appListScrolledComposite.dispose();
            this.appListScrolledComposite = null;
        }
        if (this.appListComp != null) {
            this.appListComp.dispose();
            this.appListComp = null;
        }
        this.appListScrolledComposite = new ScrolledComposite(this.appListParentComp, 512);
        this.appListScrolledComposite.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.appListScrolledComposite.setLayoutData((Object)data);
        this.appListScrolledComposite.setExpandHorizontal(true);
        this.appListScrolledComposite.setExpandVertical(true);
        this.appListScrolledComposite.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.appListComp = new Composite((Composite)this.appListScrolledComposite, 0);
        this.appListComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        this.appListComp.setLayout((Layout)new RowLayout(512));
        this.appListScrolledComposite.setContent((Control)this.appListComp);
        if (pkgMap != null) {
            Composite buttonComp = new Composite(this.appListComp, 0);
            buttonComp.setLayoutData((Object)new RowData(-1, 15));
            buttonComp.setLayout((Layout)new FillLayout());
            for (Map.Entry<String, PackageInfo> entry : pkgMap.entrySet()) {
                for (AppInfo appInfo : entry.getValue().getAppInfos()) {
                    this.flatAppMapByID.put(appInfo.getAppID(), appInfo);
                }
            }
            for (Map.Entry<String, PackageInfo> entry : this.flatAppMapByID.entrySet()) {
                AppInfo appInfo;
                appInfo = (AppInfo)((Object)entry.getValue());
                if (appInfo.isSpecialApp()) continue;
                DACustomFeatureToggleButton toggle = this.createToggleButton(this.appListComp, appInfo.getLabel(), appInfo.getAppID());
                toggle.addListener(4, this.toggleUpListener);
                toggle.addListener(3, this.toggleDownListener);
                toggle.addListener(6, this.cursorListener);
                toggle.addListener(7, this.cursorListener);
                this.appToggleList.add(toggle);
            }
        }
        this.appListParentComp.layout(true);
        this.appListScrolledComposite.layout();
        this.appListScrolledComposite.setMinSize(this.appListComp.computeSize(-1, -1));
    }

    public boolean selectApp(AppInfo curApp) {
        String selectedAppId = curApp.getAppID();
        for (DACustomFeatureToggleButton toggleButton : this.appToggleList) {
            if (!toggleButton.getToolTipText().equals(selectedAppId)) continue;
            toggleButton.setToggled(true);
            toggleButton.getParent().setBackground(ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
            this.targetDialog.getInfoPage().drawAppInfoPage(curApp);
            this.targetDialog.setOKButtonEnable(true);
            return true;
        }
        return false;
    }

    private DACustomFeatureToggleButton createToggleButton(Composite composit, String appName, String appID) {
        Composite buttonComp = new Composite(composit, 0);
        buttonComp.setLayoutData((Object)new RowData(-1, 65));
        buttonComp.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        buttonComp.setLayout((Layout)new FormLayout());
        Image normalImage = ImageResources.APP_NOR;
        Image pushImage = ImageResources.APP_SEL;
        Image hoverImage = ImageResources.APP_OVER;
        DACustomFeatureToggleButton toggle = new DACustomFeatureToggleButton(buttonComp, 0);
        toggle.setColors(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND, ColorResources.FEATURE_FEATURELISTCOMP_SELECT_BACKGROUND);
        toggle.setButtonImages(normalImage, pushImage, hoverImage, normalImage, pushImage, hoverImage, pushImage);
        toggle.setButtonImagePoint(new Point(0, 0));
        this.setTitle(toggle, appName, appID);
        toggle.setFontColors(ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR, ColorResources.SETTING_COLOR);
        toggle.setButtonFont(FontResources.SETTING_BUTTON_FONT);
        toggle.setBackground(ColorResources.FEATURE_FEATURELISTCOMP_NORMAL_BACKGROUND);
        toggle.setToolTipText(appID);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 13);
        data.left = new FormAttachment(0, 20);
        data.height = 40;
        data.width = 254;
        toggle.setLayoutData((Object)data);
        return toggle;
    }

    private String normalizeStringLength(String str) {
        int len = str.length();
        if (len > 25) {
            return String.valueOf(str.substring(0, 10)) + "..." + str.substring(len - 10 - 4, len);
        }
        return str;
    }

    private void setTitle(DACustomFeatureToggleButton toggle, String appLabel, String appID) {
        StringBuilder title = new StringBuilder();
        title.append(this.normalizeStringLength(appLabel));
        title.append(CommonConstants.NEW_LINE);
        title.append(this.normalizeStringLength(appID));
        toggle.setTitle(title.toString());
        toggle.setFontPoint(new Point(55, 0));
    }
}

