/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets.table;

import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.CheckBoxRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableToggleRenderer;

public class DATableCellRenderer
extends DefaultCellRenderer {
    protected int leftMargin = 4;
    protected int rightMargin = 4;
    protected int topMargin = 0;
    protected int bottomMargin = 0;
    protected int textTopMargin = 1;
    protected int insideMargin = 3;
    protected DATableToggleRenderer toggleRenderer;
    protected CheckBoxRenderer checkRenderer;

    public void paint(GC gc, Object value) {
        int len;
        Image image;
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        boolean drawAsSelected = this.isSelected();
        boolean drawBackground = true;
        if (this.isCellSelected()) {
            drawAsSelected = true;
        }
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_START);
            gc.setBackground(ColorResources.TABLE_CONTENTS_SELECTED_START);
        } else if (item.getParent().isEnabled()) {
            Color bg = item.getBackground();
            if (bg != null) {
                gc.setBackground(bg);
            } else {
                drawBackground = false;
            }
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        if (drawBackground && drawAsSelected) {
            gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        } else if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y + 1, this.getBounds().width, this.getBounds().height);
        }
        int x = this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            if (drawAsSelected) {
                this.toggleRenderer.setSelected(true);
            } else {
                this.toggleRenderer.setSelected(false);
            }
            this.toggleRenderer.setExpanded(item.isExpanded());
            this.toggleRenderer.setHover(this.getHoverDetail().equals("toggle"));
            this.toggleRenderer.setLocation(this.getBounds().x + x, (this.getBounds().height - this.toggleRenderer.getBounds().height) / 2 + this.getBounds().y);
            this.toggleRenderer.paint(gc, item);
            x += this.toggleRenderer.getBounds().width + this.insideMargin;
        }
        if (this.isCheck()) {
            this.checkRenderer.setChecked(item.getChecked(this.getColumn()));
            this.checkRenderer.setGrayed(item.getGrayed(this.getColumn()));
            if (!item.getParent().isEnabled()) {
                this.checkRenderer.setGrayed(true);
            }
            this.checkRenderer.setHover(this.getHoverDetail().equals("check"));
            this.checkRenderer.setBounds(this.getBounds().x + x, (this.getBounds().height - this.checkRenderer.getBounds().height) / 2 + this.getBounds().y, this.checkRenderer.getBounds().width, this.checkRenderer.getBounds().height);
            this.checkRenderer.paint(gc, null);
            x += this.checkRenderer.getBounds().width + this.insideMargin;
        }
        if ((image = item.getImage(this.getColumn())) != null) {
            Rectangle bounds = this.getBounds();
            Rectangle imageBounds = image.getBounds();
            int y = bounds.y;
            gc.drawImage(image, bounds.x + x, y += (bounds.height - imageBounds.height) / 2);
            x += imageBounds.width + this.insideMargin;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        String text = item.getText(this.getColumn());
        if (this.getAlignment() == 131072) {
            len = gc.stringExtent((String)text).x;
            if (len < width) {
                x += width - len;
            }
        } else if (this.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        this.drawPercentGraph(gc, drawAsSelected, item);
        if (drawAsSelected) {
            gc.setForeground(ColorResources.TABLE_CONTENTS_SELECTED_FONT_COLOR);
        } else {
            Color fontColor = item.getForeground();
            if (fontColor != null) {
                gc.setForeground(fontColor);
            } else {
                gc.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
            }
        }
        gc.setFont(FontResources.TABLE_CELL_FONT);
        if (this.isTree() && this.getColumn() != 0) {
            gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
        } else if (!this.isTree() || this.getColumn() != 0) {
            gc.drawText(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin, true);
        }
        if (item.getParent().getLinesVisible()) {
            gc.setForeground(ColorResources.TABLE_LINE);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        }
        if (this.isCellFocus()) {
            Rectangle focusRect = new Rectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width, this.getBounds().height + 1);
            gc.setForeground(ColorResources.RED);
            gc.drawRectangle(focusRect);
            if (this.isFocus()) {
                ++focusRect.x;
                focusRect.width -= 2;
                ++focusRect.y;
                focusRect.height -= 2;
                gc.drawRectangle(focusRect);
            }
        }
    }

    protected void drawPercentGraph(GC gc, boolean drawAsSelected, GridItem item) {
    }

    protected int getToggleIndent(GridItem item) {
        return item.getLevel() * 20;
    }

    public void setLeftMargin(int margin) {
        this.leftMargin = margin;
    }

    public void setTextTopMargin(int margin) {
        this.textTopMargin = margin;
    }

    public void setTree(boolean tree) {
        super.setTree(tree);
        if (tree) {
            this.toggleRenderer = new DATableToggleRenderer();
            this.toggleRenderer.setDisplay(this.getDisplay());
        }
    }

    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridItem item = (GridItem)value;
        gc.setFont(item.getFont(this.getColumn()));
        int x = 0;
        x += this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            x += this.toggleRenderer.getBounds().width + this.insideMargin;
        }
        if (this.isCheck()) {
            x += this.checkRenderer.getBounds().width + this.insideMargin;
        }
        int y = 0;
        Image image = item.getImage(this.getColumn());
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            y = this.topMargin + imageBounds.height + this.bottomMargin;
            x += imageBounds.width + this.insideMargin;
        }
        y = Math.max(y, this.topMargin + gc.getFontMetrics().getHeight() + this.bottomMargin);
        return new Point(x += gc.stringExtent((String)item.getText((int)this.getColumn())).x + this.rightMargin, y);
    }

    public boolean notify(int event, Point point, Object value) {
        GridItem item = (GridItem)value;
        if (this.isCheck()) {
            if (event == 5 && this.overCheck(item, point)) {
                this.setHoverDetail("check");
                return true;
            }
            if (event == 3 && this.overCheck(item, point)) {
                item.setChecked(this.getColumn(), !item.getChecked(this.getColumn()));
                item.getParent().redraw();
                item.fireCheckEvent(this.getColumn());
                return true;
            }
        }
        if (this.isTree() && this.hasChildren(item)) {
            if (event == 5 && this.overToggle(item, point)) {
                this.setHoverDetail("toggle");
                return true;
            }
            if (event == 3 && this.overToggle(item, point)) {
                item.setExpanded(!item.isExpanded());
                item.getParent().redraw();
                if (item.isExpanded()) {
                    item.fireEvent(17);
                } else {
                    item.fireEvent(18);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean hasChildren(GridItem item) {
        return item.hasChildren();
    }

    protected boolean overCheck(GridItem item, Point point) {
        int yStart;
        point = new Point(point.x, point.y);
        point.x -= this.getBounds().x - 1;
        point.y -= this.getBounds().y - 1;
        int x = this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            x += this.toggleRenderer.getSize().x + this.insideMargin;
        }
        return point.x >= x && point.x < x + this.checkRenderer.getSize().x && point.y >= (yStart = (this.getBounds().height - this.checkRenderer.getBounds().height) / 2) && point.y < yStart + this.checkRenderer.getSize().y;
    }

    protected boolean overToggle(GridItem item, Point point) {
        int yStart;
        point = new Point(point.x, point.y);
        point.x -= this.getBounds().x - 1;
        point.y -= this.getBounds().y - 1;
        int x = this.leftMargin;
        return point.x >= (x += this.getToggleIndent(item)) && point.x < x + this.toggleRenderer.getSize().x && point.y >= (yStart = (this.getBounds().height - this.toggleRenderer.getBounds().height) / 2) && point.y < yStart + this.toggleRenderer.getSize().y;
    }

    public void setCheck(boolean check) {
        super.setCheck(check);
        if (check) {
            this.checkRenderer = new CheckBoxRenderer();
            this.checkRenderer.setDisplay(this.getDisplay());
        } else {
            this.checkRenderer = null;
        }
    }

    public Rectangle getTextBounds(GridItem item, boolean preferred) {
        Image image;
        int x = this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            x += this.toggleRenderer.getBounds().width + this.insideMargin;
        }
        if (this.isCheck()) {
            x += this.checkRenderer.getBounds().width + this.insideMargin;
        }
        if ((image = item.getImage(this.getColumn())) != null) {
            x += image.getBounds().width + this.insideMargin;
        }
        Rectangle bounds = new Rectangle(x, this.topMargin, 0, 0);
        GC gc = new GC((Drawable)item.getParent());
        gc.setFont(item.getFont(this.getColumn()));
        Point size = gc.stringExtent(item.getText(this.getColumn()));
        bounds.height = size.y;
        bounds.width = preferred ? size.x : this.getBounds().width - x - this.rightMargin;
        gc.dispose();
        return bounds;
    }
}

