/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.StreamBufferBase;

public class ByteBufferStreamBuffer
extends StreamBufferBase {
    private ByteBuffer buffer;

    public ByteBufferStreamBuffer(ByteBuffer buffer) throws IOException {
        super(buffer.order(), 0L, buffer.capacity());
        this.buffer = buffer;
    }

    public ByteBufferStreamBuffer(ByteBuffer buffer, long position, long size) {
        super(buffer.order(), position, size);
        this.buffer = buffer;
    }

    @Override
    protected void fetchPage(byte[] buffer, long sourceOffset, int count) {
        if (sourceOffset > Integer.MAX_VALUE) {
            throw new BufferUnderflowException();
        }
        this.buffer.position((int)sourceOffset);
        this.buffer.get(buffer, 0, count);
    }

    @Override
    protected IStreamBuffer createSubBuffer(long offset, long size) {
        return new ByteBufferStreamBuffer(this.buffer, offset, size);
    }
}

