/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import org.eclipse.cdt.debug.edc.ITCFServiceManager;
import org.eclipse.cdt.debug.edc.MessageLogger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.PersistentCache;
import org.eclipse.cdt.debug.edc.internal.TCFServiceManager;
import org.eclipse.cdt.debug.edc.tcf.extension.services.ILogging;
import org.eclipse.cdt.debug.edc.tcf.extension.services.ISettings;
import org.eclipse.cdt.debug.edc.tcf.extension.services.LoggingProxy;
import org.eclipse.cdt.debug.edc.tcf.extension.services.SettingsProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class EDCDebugger
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.edc";
    private static EDCDebugger plugin;
    private volatile DebugTrace trace;
    private final String traceLock = new String("trace lock");
    private ITCFServiceManager tcfServiceManager;
    private PersistentCache cache;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        plugin = this;
        if (!this.getBundle().getSymbolicName().equals(PLUGIN_ID)) {
            throw new IllegalStateException("PLUGIN_ID constant is not correct");
        }
        EDCTrace.init();
        this.installChannelListener();
    }

    private void installChannelListener() {
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Protocol.addChannelOpenListener((Protocol.ChannelOpenListener)new Protocol.ChannelOpenListener(){

                    public void onChannelOpen(IChannel channel) {
                        if (channel.getRemoteService("Logging") != null) {
                            channel.setServiceProxy(ILogging.class, (IService)new LoggingProxy(channel));
                        }
                        if (channel.getRemoteService("Settings") != null) {
                            channel.setServiceProxy(ISettings.class, (IService)new SettingsProxy(channel));
                        }
                    }
                });
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this.cache != null) {
            this.cache.flushAll();
        }
        plugin = null;
        if (this.tcfServiceManager != null) {
            ((TCFServiceManager)this.tcfServiceManager).shutdown();
        }
        super.stop(context);
    }

    public static EDCDebugger getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return EDCDebugger.getDefault().getBundle().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugTrace getTrace() {
        block6: {
            String string = this.traceLock;
            synchronized (string) {
                block5: {
                    if (this.trace != null) break block6;
                    if (this.context != null) break block5;
                    return null;
                }
                ServiceTracker tracker = new ServiceTracker(this.context, DebugOptions.class.getName(), null);
                tracker.open();
                DebugOptions debugOptions = (DebugOptions)tracker.getService();
                if (debugOptions != null) {
                    this.trace = debugOptions.newDebugTrace(this.getBundle().getSymbolicName());
                }
                tracker.close();
            }
        }
        return this.trace;
    }

    public ITCFServiceManager getServiceManager() {
        if (this.tcfServiceManager == null) {
            this.tcfServiceManager = new TCFServiceManager();
        }
        return this.tcfServiceManager;
    }

    public static CoreException newCoreException(String msg, Throwable t) {
        if ((msg == null || msg.length() == 0) && t instanceof CoreException) {
            return new CoreException(((CoreException)t).getStatus());
        }
        return new CoreException((IStatus)new Status(4, PLUGIN_ID, msg, t));
    }

    public static CoreException newCoreException(String msg) {
        return new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    public static DebugException newDebugException(String msg, Throwable t) {
        if ((msg == null || msg.length() == 0) && t instanceof CoreException) {
            return new DebugException(((CoreException)t).getStatus());
        }
        return new DebugException((IStatus)new Status(4, PLUGIN_ID, msg, t));
    }

    public static DebugException newDebugException(String msg) {
        return new DebugException((IStatus)new Status(4, PLUGIN_ID, msg));
    }

    public static MessageLogger getMessageLogger() {
        return new MessageLogger(){

            @Override
            public String getPluginID() {
                return EDCDebugger.PLUGIN_ID;
            }

            @Override
            public Plugin getPlugin() {
                return plugin;
            }
        };
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static IStatus dsfRequestFailedStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 10004, message, exception);
    }

    public PersistentCache getCache() {
        if (this.cache == null) {
            this.cache = new PersistentCache(this.getStateLocation().append("cached_data"));
        }
        return this.cache;
    }
}

