/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.snapshot;

import org.eclipse.cdt.debug.edc.launch.AbstractFinalLaunchSequence;
import org.eclipse.cdt.debug.edc.launch.EDCLaunch;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SnapshotLaunchSequence
extends AbstractFinalLaunchSequence {
    private final Sequence.Step[] steps;

    public SnapshotLaunchSequence(DsfExecutor executor, EDCLaunch launch, IProgressMonitor pm) {
        super(executor, launch, pm, "Configuring Snapshot Launch", "Aborting configuring Snapshot Launch");
        this.steps = new Sequence.Step[]{this.trackerStep, new Sequence.Step(){

            public void execute(RequestMonitor requestMonitor) {
                try {
                    int snapIndex = SnapshotLaunchSequence.this.getLaunch().getAlbum().getCurrentSnapshotIndex();
                    SnapshotLaunchSequence.this.getLaunch().getAlbum().openSnapshot(snapIndex);
                    requestMonitor.done();
                }
                catch (Exception e) {
                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", "Failed to open snapshot. Reason: " + e.getLocalizedMessage()));
                }
            }
        }};
    }

    @Override
    public Sequence.Step[] getSteps() {
        return this.steps;
    }

    @Override
    protected boolean useLocalAgentOnly() {
        return true;
    }

    @Override
    protected void specifyRequiredPeer() {
    }
}

