/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProvider;
import org.eclipse.cdt.debug.edc.symbols.IDebugInfoProviderFactory;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class DebugInfoProviderFactory {
    private static Map<String, IDebugInfoProviderFactory> providerMap = new HashMap<String, IDebugInfoProviderFactory>();

    static {
        DebugInfoProviderFactory.initializeExtensions();
    }

    public static IDebugInfoProvider createFor(IPath binaryPath, IExecutableSymbolicsReader exeReader) {
        for (Map.Entry<String, IDebugInfoProviderFactory> entry : providerMap.entrySet()) {
            String name = entry.getKey();
            IDebugInfoProviderFactory providerProvider = entry.getValue();
            try {
                IDebugInfoProvider provider = providerProvider.createDebugInfoProvider(binaryPath, exeReader);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError("Debug info reader " + name + " failed", t);
            }
        }
        return null;
    }

    protected static void initializeExtensions() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.debug.edc.debugInfoProviderFactory");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String name = element.getAttribute("name");
                IDebugInfoProviderFactory formatProvider = (IDebugInfoProviderFactory)element.createExecutableExtension("class");
                providerMap.put(name, formatProvider);
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError("Could not create executable symbolics provider extension", e);
            }
            ++n2;
        }
    }
}

