/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.files;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReader;
import org.eclipse.cdt.debug.edc.symbols.IExecutableSymbolicsReaderFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ExecutableSymbolicsReaderFactory {
    private static final String SYM_EXTENSION = "sym";
    private static final String DBG_EXTENSION = "dbg";
    private static Map<String, IExecutableSymbolicsReaderFactory> providerMap = new HashMap<String, IExecutableSymbolicsReaderFactory>();

    static {
        ExecutableSymbolicsReaderFactory.initializeExtensions();
    }

    public static IExecutableSymbolicsReader createFor(IPath binaryFile) {
        IExecutableSymbolicsReaderFactory provider = null;
        String providerName = null;
        int highestConfidence = 0;
        for (Map.Entry<String, IExecutableSymbolicsReaderFactory> entry : providerMap.entrySet()) {
            IExecutableSymbolicsReaderFactory factory = entry.getValue();
            try {
                int confidence = factory.getConfidence(binaryFile);
                if (confidence <= highestConfidence) continue;
                highestConfidence = confidence;
                provider = factory;
                providerName = entry.getKey();
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError("Executable reader " + entry.getKey() + " failed", t);
            }
        }
        if (provider != null) {
            try {
                IExecutableSymbolicsReader reader = provider.createExecutableSymbolicsReader(binaryFile);
                if (reader != null) {
                    return reader;
                }
            }
            catch (Throwable t) {
                EDCDebugger.getMessageLogger().logError("Executable reader " + providerName + " failed", t);
            }
        }
        return null;
    }

    public static IPath findSymbolicsFile(IPath binaryFile) {
        ArrayList<IPath> candidates = new ArrayList<IPath>();
        IPath symFile = binaryFile.removeFileExtension().addFileExtension(SYM_EXTENSION);
        if (symFile.toFile().exists()) {
            candidates.add(symFile);
        }
        if ((symFile = binaryFile.removeFileExtension().addFileExtension(DBG_EXTENSION)).toFile().exists()) {
            candidates.add(symFile);
        }
        if ((symFile = binaryFile.addFileExtension(SYM_EXTENSION)).toFile().exists()) {
            candidates.add(symFile);
        }
        if ((symFile = binaryFile.addFileExtension(DBG_EXTENSION)).toFile().exists()) {
            candidates.add(symFile);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() > 1) {
            Collections.sort(candidates, new Comparator<IPath>(){

                @Override
                public int compare(IPath o1, IPath o2) {
                    long diff = o1.toFile().lastModified() - o2.toFile().lastModified();
                    return diff > 0L ? -1 : (diff < 0L ? 1 : 0);
                }
            });
        }
        return (IPath)candidates.get(0);
    }

    protected static void initializeExtensions() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.debug.edc.executableSymbolicsReaderFactory");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String name = element.getAttribute("name");
                IExecutableSymbolicsReaderFactory formatProvider = (IExecutableSymbolicsReaderFactory)element.createExecutableExtension("class");
                providerMap.put(name, formatProvider);
            }
            catch (Exception e) {
                EDCDebugger.getMessageLogger().logError("Could not create executable symbolics provider extension", e);
            }
            ++n2;
        }
    }
}

