/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.communicator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.communicator.CommunicatorUtils;
import org.tizen.dynamicanalyzer.communicator.DeviceInfo;
import org.tizen.dynamicanalyzer.communicator.DeviceNotFoundException;
import org.tizen.dynamicanalyzer.communicator.ProcessAdditionalInfo;
import org.tizen.dynamicanalyzer.communicator.SubCommunicator;
import org.tizen.dynamicanalyzer.communicator.UnsupportedProtocolException;
import org.tizen.dynamicanalyzer.control.ApplistManager;
import org.tizen.dynamicanalyzer.control.IProgress;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.BinaryInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.SyncResult;

public class DACommunicator {
    public static final int READ_BUFFER_SIZE = 1024;

    public static boolean isEmulator() throws DeviceNotFoundException {
        DeviceInfo device = Global.getCurrentDeviceInfo();
        if (device != null) {
            return device.isEmulator();
        }
        throw new DeviceNotFoundException();
    }

    public static DAResult removeFile(String path) {
        DeviceInfo device = Global.getCurrentDeviceInfo();
        if (device != null) {
            CommunicatorUtils.execShellCommand(device.getIDevice(), "rm -rf " + path);
            return new DAResult(DAResult.ErrorCode.SUCCESS);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult pullFromCurrentDevice(String from, String to) {
        return DACommunicator.pull(Global.getCurrentDeviceInfo(), from, to);
    }

    public static DAResult pull(DeviceInfo device, String from, String to) {
        if (device != null) {
            SyncResult res = CommunicatorUtils.pull(device.getIDevice(), from, to);
            if (res != null && res.isOk()) {
                return new DAResult(DAResult.ErrorCode.SUCCESS);
            }
            return new DAResult(DAResult.ErrorCode.ERR_DOWNLOAD_FILE_FAILED);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static void pullDaemonLog() {
        DACommunicator.exportCustomPathDaemonLog(PathManager.DA_LOG_PATH);
    }

    public static String getRealpath(String path) {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            try {
                DAResult result = curDev.getCommunicator().getSubCommunicator().sendRealPathMessage(null, path);
                if (result.isSuccess()) {
                    BinaryInfo binInfo = curDev.getDeviceStatusInfo().getBinaryInfo(path);
                    return binInfo.getRealPath();
                }
                Logger.warning((String)"unable to get real path of %s", (Object[])new Object[]{path});
            }
            catch (UnsupportedProtocolException e) {
                Logger.exception((Throwable)e);
            }
        }
        return null;
    }

    public static Map<Integer, String> getProcessList() {
        DeviceInfo device = Global.getCurrentDeviceInfo();
        if (device == null) {
            return null;
        }
        if (!CommunicatorUtils.becomeSuperUser(device.getIDevice(), true)) {
            return null;
        }
        TreeMap<Integer, String> processMap = new TreeMap<Integer, String>();
        final ArrayList cmdResultMultiLines = new ArrayList();
        CommunicatorUtils.execShellCommand(device.getIDevice(), "ps -ew -o pid,command", (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    cmdResultMultiLines.add(appLines[i]);
                    ++i;
                }
            }
        });
        CommunicatorUtils.becomeSuperUser(device.getIDevice(), false);
        int size = cmdResultMultiLines.size();
        int i = 1;
        while (i < size) {
            String line = (String)cmdResultMultiLines.get(i);
            String[] splitline = (line = line.trim()).split(" ", 2);
            if (splitline.length == 2) {
                int pid = Integer.parseInt(splitline[0]);
                processMap.put(pid, splitline[1]);
            }
            ++i;
        }
        return processMap;
    }

    public static String getProcessName(int pid) {
        DeviceInfo device = Global.getCurrentDeviceInfo();
        if (device == null) {
            return null;
        }
        String processName = null;
        final ArrayList cmdResultMultiLines = new ArrayList();
        String command = String.format("ps -p %d -o comm=rcu_sched", pid);
        CommunicatorUtils.execShellCommand(device.getIDevice(), command, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    cmdResultMultiLines.add(appLines[i]);
                    ++i;
                }
            }
        });
        processName = cmdResultMultiLines.size() == 1 ? "unknown process" : (String)cmdResultMultiLines.get(1);
        return processName;
    }

    public static String getBinaryDetailInformation(String path) {
        DeviceInfo device = Global.getCurrentDeviceInfo();
        if (device == null) {
            return null;
        }
        final ArrayList cmdlines = new ArrayList();
        CommunicatorUtils.execShellCommand(device.getIDevice(), "rpm -qf " + path, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                if (lines.length > 0) {
                    cmdlines.add(lines[0]);
                }
            }
        });
        if (cmdlines.isEmpty()) {
            return "";
        }
        return (String)cmdlines.get(0);
    }

    public static Map<String, PackageInfo> updatePkgMapFromTarget() {
        return DACommunicator.updatePkgMapFromTarget(Global.getCurrentDeviceInfo());
    }

    public static List<String> composePkginfoLinesFor(String appID, String appLabel, String appType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("%s [%s] %s [%s] %s [%s] %s [1]", "pkg_type", "unknown", "pkgid", appID, "version", "unknown", "preload"));
        result.add(String.valueOf(AppInfo.PROPERTY.APPID.name) + ":" + appID);
        result.add(String.valueOf(AppInfo.PROPERTY.PACKAGE.name) + ":" + appID);
        result.add(String.valueOf(AppInfo.PROPERTY.LABEL.name) + ":" + appLabel);
        result.add(String.valueOf(AppInfo.PROPERTY.APPTYPE.name) + ":" + appType);
        result.add("");
        return result;
    }

    public static Map<String, PackageInfo> updatePkgMapFromTarget(DeviceInfo curDev) {
        if (curDev == null) {
            return null;
        }
        final ArrayList<String> pkginfoLines = new ArrayList<String>();
        CommunicatorUtils.execShellCommand(curDev.getIDevice(), "/usr/bin/pkginfo --listpkg", (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] appLines) {
                int i = 0;
                while (i < appLines.length) {
                    pkginfoLines.add(appLines[i]);
                    ++i;
                }
            }
        });
        pkginfoLines.add("");
        pkginfoLines.addAll(DACommunicator.composePkginfoLinesFor("da.id.dummy.app.running", "[Running process]", "running"));
        pkginfoLines.addAll(DACommunicator.composePkginfoLinesFor("da.id.dummy.app.executable", "[Common executable]", "executable"));
        pkginfoLines.addAll(DACommunicator.composePkginfoLinesFor("da.id.dummy.app.systemwide", "[Without executable]", "none"));
        curDev.updatePackageList(ApplistManager.parseTizenPkginfo(pkginfoLines, new ArrayList<String>(), new ArrayList<String>(), curDev.getIDevice().getAppInstallPath()));
        return curDev.getPackageInfoMap();
    }

    public static DAResult startTrace(IProgress progress) {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev == null) {
            return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
        }
        SubCommunicator subComm = curDev.getCommunicator().getSubCommunicator();
        try {
            AppInfo curApp = Global.getCurrentApplication();
            List<String> binPaths = curApp.getProcessInformation();
            binPaths.remove(curApp.getExecBinaryPath());
            DAResult ret = DACommunicator.addInstrumentation(binPaths);
            return ret.isSuccess() ? subComm.sendTraceStartMessage(progress) : ret;
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            Logger.error((Object)"It is not supported to send start trace message by communicator");
            return new DAResult(DAResult.ErrorCode.ERR_PROTOCOL_NOT_SUPPORTED);
        }
    }

    public static DAResult stopTrace() {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev == null) {
            return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
        }
        SubCommunicator subComm = curDev.getCommunicator().getSubCommunicator();
        try {
            AppInfo curApp = Global.getCurrentApplication();
            List<String> binPaths = curApp.getProcessInformation();
            binPaths.remove(curApp.getExecBinaryPath());
            new Thread(() -> {
                try {
                    DACommunicator.removeInstrumentation(binPaths);
                }
                catch (UnsupportedProtocolException e) {
                    Logger.error((Object)e);
                }
            }).start();
            return subComm.sendTraceStopMessage(null);
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            Logger.error((Object)"It is not supported to send stop trace message by communicator");
            return new DAResult(DAResult.ErrorCode.ERR_PROTOCOL_NOT_SUPPORTED);
        }
    }

    public static DAResult configure() throws InterruptedException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            try {
                return curDev.getCommunicator().getSubCommunicator().sendConfigurationMessage(null);
            }
            catch (UnsupportedProtocolException unsupportedProtocolException) {
                Logger.error((Object)"It is not supported to send configuration message by communicator");
                return new DAResult(DAResult.ErrorCode.ERR_PROTOCOL_NOT_SUPPORTED);
            }
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult getBinaryInformation(List<String> paths) throws InterruptedException, UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendBinaryInfoMessage(null, paths);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult addInstrumentation(List<String> paths) throws UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendInstrumentAddMessage(null, paths);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult removeInstrumentation(List<String> paths) throws UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendInstrumentRemoveMessage(null, paths);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult getProcessAdditionalInfo(List<Integer> pids, Map<Integer, ProcessAdditionalInfo> infoMap) throws InterruptedException, UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendProcessAddInfoMessage(null, pids, infoMap);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult captureScreenshot() throws InterruptedException, UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendScreenshotMessage(null);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult requestUIHierarchy(int requestOption) throws InterruptedException, UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendUIHierarchyMessage(null, requestOption);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult requestUIScreenshot(long uiAddress) throws InterruptedException, UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendUIScreenshotMessage(null, uiAddress);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static DAResult cancelRequestUIHierarchy() throws InterruptedException, UnsupportedProtocolException {
        DeviceInfo curDev = Global.getCurrentDeviceInfo();
        if (curDev != null) {
            return curDev.getCommunicator().getSubCommunicator().sendUIHierarchyCancelMessage(null);
        }
        return new DAResult(DAResult.ErrorCode.ERR_NO_DEVICE);
    }

    public static void exportCustomPathDaemonLog(String path) {
        DeviceInfo device = Global.getCurrentDeviceInfo();
        if (device == null) {
            return;
        }
        String from = Global.getCurrentDeviceInfo().isNoRootSwapInstalled() ? "/run/swap/manager.log" : "/tmp/daemonlog.da";
        String command = "stat -c %s " + from;
        final ArrayList cmdResultMultiLines = new ArrayList();
        CommunicatorUtils.execShellCommand(device.getIDevice(), command, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                int i = 0;
                while (i < lines.length) {
                    cmdResultMultiLines.add(lines[i]);
                    ++i;
                }
            }
        });
        long filesize = -1L;
        if (cmdResultMultiLines.size() > 0) {
            filesize = Long.parseLong((String)cmdResultMultiLines.get(0));
        }
        if (filesize > 0L && filesize < 0x100000L) {
            String to = String.valueOf(path) + File.separator + "da_daemon_log_" + PathManager.getLogPostFix();
            SyncResult res = CommunicatorUtils.pull(device.getIDevice(), from, to);
            if (res != null && res.isOk()) {
                Logger.debug((Object)"daemon log copying success!!");
            } else {
                Logger.debug((Object)("Failed to get " + from));
            }
            AnalyzerUtil.checkLogs(PathManager.DA_LOG_PATH, "da_daemon_log_", 3);
        } else {
            Logger.debug((Object)"daemon log file is too large or does not exist");
        }
    }

    public static List<String> getApplicationLibs(String packageId) {
        final ArrayList<String> libPaths = new ArrayList<String>();
        CommunicatorUtils.execShellCommand(Global.getCurrentDeviceInfo().getIDevice(), String.format("find `/usr/bin/pkginfo --pkg %s | sed -rn 's/^root_path : (.*)/\\1/p'` -name *.so 2>/dev/null", packageId), (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    libPaths.add(line);
                    ++n2;
                }
            }
        });
        return libPaths;
    }
}

