/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.project.AppInfo;
import org.tizen.dynamicanalyzer.project.PackageInfo;

public class ApplistManager {
    public static Map<String, PackageInfo> parseTizenPkginfo(List<String> pkginfo, List<String> unittest, List<String> ime, String appInstallPath) {
        HashMap<String, PackageInfo> pkgInfoHash = new HashMap<String, PackageInfo>();
        List<String> unittestList = ApplistManager.parseTizenUnittest(appInstallPath, unittest);
        List<String> imeList = ApplistManager.parseTizenIme(ime);
        PackageInfo pkg = null;
        AppInfo app = null;
        int size = pkginfo.size();
        int i = 0;
        while (i < size) {
            String line = pkginfo.get(i);
            if (line.startsWith("pkg_type")) {
                pkg = ApplistManager.makePackage(line);
                if (pkg != null) {
                    pkgInfoHash.put(pkg.getPackageId(), pkg);
                }
                app = null;
            } else if (line.startsWith(AppInfo.PROPERTY.APPID.name)) {
                if (pkg != null) {
                    app = ApplistManager.makeApplication(line);
                    if (app != null) {
                        if (!ApplistManager.isInList(unittestList, pkg.getPackageId()) && !ApplistManager.isInList(imeList, app.getAppID())) {
                            pkg.addAppInfo(app);
                        } else {
                            app = null;
                        }
                    }
                } else {
                    app = null;
                }
            } else if (!line.isEmpty() && app != null) {
                ApplistManager.constructAppProperty(app, line);
            }
            ++i;
        }
        return pkgInfoHash;
    }

    private static List<String> parseTizenUnittest(String appInstallPath, List<String> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        ArrayList<String> unittestList = new ArrayList<String>();
        for (String line : lines) {
            if (!line.contains(appInstallPath)) continue;
            line = line.replaceFirst(String.valueOf(appInstallPath) + "/", "");
            int index = line.indexOf("/");
            line = line.substring(0, index);
            unittestList.add(line);
        }
        return unittestList;
    }

    private static List<String> parseTizenIme(List<String> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        ArrayList<String> imeList = new ArrayList<String>();
        for (String line : lines) {
            String appId = "appid";
            if (!line.contains("apptype") || !line.contains("c++app")) continue;
            line = line.trim();
            int index = line.indexOf(appId);
            line = line.substring(index + appId.length() + 2, line.length() - 1);
            imeList.add(line);
        }
        return imeList;
    }

    private static PackageInfo makePackage(String line) {
        PackageInfo pkgInfo = new PackageInfo();
        String[] splited = line.split("[\\[\\]]");
        int size = splited.length;
        int i = 0;
        while (i < size - 1) {
            String key = splited[i].trim();
            String value = splited[i + 1].trim();
            if (key.equals("pkg_type")) {
                pkgInfo.setPkgType(value);
            } else if (key.equals("pkgid")) {
                pkgInfo.setPackageId(value);
            } else if (key.equals("version")) {
                pkgInfo.setVersion(value);
            } else if (key.equals("preload")) {
                pkgInfo.setPreload(Integer.parseInt(value));
            } else if (key.equals("installed_time")) {
                pkgInfo.setInstallTime(Long.parseLong(value));
            }
            i += 2;
        }
        if (pkgInfo.getPackageId() == null) {
            return null;
        }
        if (!AnalyzerManager.isPlatformSDK() && pkgInfo.getPreload() != 0) {
            return null;
        }
        return pkgInfo;
    }

    private static AppInfo makeApplication(String line) {
        if (!line.startsWith(AppInfo.PROPERTY.APPID.name)) {
            return null;
        }
        AppInfo appInfo = new AppInfo();
        if (ApplistManager.constructAppProperty(appInfo, line)) {
            return appInfo;
        }
        return null;
    }

    private static boolean constructAppProperty(AppInfo app, String line) {
        int index = line.indexOf(58);
        if (index > 0) {
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1, line.length()).trim();
            AppInfo.PROPERTY p = AppInfo.PROPERTY.get(key);
            if (p != null) {
                app.setInfo(p.index, value);
            }
            return true;
        }
        return false;
    }

    private static boolean isInList(List<String> list, String item) {
        if (list != null && !list.isEmpty()) {
            for (String id : list) {
                if (!id.equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInBlackList(AppInfo application) {
        return application.getAppID().contains("_AppControl") || application.getComponent().equals("widgetapp") || application.getAppComp().equals("widgetapp");
    }
}

