/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.protocol;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public class DebugLog {
    private static boolean PRINT_CONTROL_LOG_TO_FILE = false;
    private static boolean PRINT_DATA_LOG_TO_FILE = false;
    private static PrintWriter controlChannelWriter = null;
    private static PrintWriter dataChannelWriter = null;

    public static void enableDebugPrint(boolean enabled) {
        PRINT_CONTROL_LOG_TO_FILE = true;
        PRINT_DATA_LOG_TO_FILE = true;
    }

    public static boolean isEnabled() {
        return PRINT_DATA_LOG_TO_FILE;
    }

    public static void openControlChannelWriter() {
        controlChannelWriter = null;
        if (PRINT_CONTROL_LOG_TO_FILE) {
            File logPath = new File(PathManager.DA_DEBUG_CONTROL_CHANNEL_LOG_FILE);
            if (logPath.exists()) {
                logPath.delete();
            }
            try {
                controlChannelWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logPath)), true);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
    }

    public static void openDataChannelWriter() {
        dataChannelWriter = null;
        if (PRINT_DATA_LOG_TO_FILE) {
            File logPath = new File(PathManager.DA_DEBUG_DATA_CHANNEL_LOG_FILE);
            if (logPath.exists()) {
                logPath.delete();
            }
            try {
                dataChannelWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logPath)), true);
            }
            catch (IOException e) {
                Logger.exception((Throwable)e);
            }
        }
    }

    public static void closeControlChannelWriter() {
        if (controlChannelWriter != null) {
            CommonUtil.tryClose((Object[])new Object[]{controlChannelWriter});
            controlChannelWriter = null;
        }
    }

    public static void closeDataChannelWriter() {
        if (dataChannelWriter != null) {
            CommonUtil.tryClose((Object[])new Object[]{dataChannelWriter});
            dataChannelWriter = null;
        }
    }

    public static void printControl(int indent, String format, Object ... objects) {
        if (controlChannelWriter != null) {
            switch (indent) {
                case 0: {
                    controlChannelWriter.printf(format, objects);
                    break;
                }
                case 1: {
                    controlChannelWriter.printf("\t" + format, objects);
                    break;
                }
                case 2: {
                    controlChannelWriter.printf("\t\t" + format, objects);
                    break;
                }
                default: {
                    controlChannelWriter.printf("\t\t" + format, objects);
                }
            }
        }
    }

    public static void printControl0(String format, Object ... objects) {
        DebugLog.printControl(0, format, objects);
    }

    public static void printControl1(String format, Object ... objects) {
        DebugLog.printControl(1, format, objects);
    }

    public static void printControl2(String format, Object ... objects) {
        DebugLog.printControl(2, format, objects);
    }

    public static void printData(int indent, String format, Object ... objects) {
        if (dataChannelWriter != null) {
            switch (indent) {
                case 0: {
                    dataChannelWriter.printf(format, objects);
                    break;
                }
                case 1: {
                    dataChannelWriter.printf("\t" + format, objects);
                    break;
                }
                case 2: {
                    dataChannelWriter.printf("\t\t" + format, objects);
                    break;
                }
                default: {
                    dataChannelWriter.printf("\t\t" + format, objects);
                }
            }
        }
    }

    public static void printData0(String format, Object ... objects) {
        DebugLog.printData(0, format, objects);
    }

    public static void printData1(String format, Object ... objects) {
        DebugLog.printData(1, format, objects);
    }

    public static void printData2(String format, Object ... objects) {
        DebugLog.printData(2, format, objects);
    }
}

