/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.setting.Feature;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;

public class FeatureData {
    private Feature key;
    private int featureType = 0;
    private int parentIndex = 0;
    private String description = null;
    private List<String> pageList = new ArrayList<String>();
    private List<String> chartList = new ArrayList<String>();
    private int minValue = 0;
    private int maxValue = 0;
    private int defaultValue = 0;
    private int overheadRanking = 0;

    public FeatureData(Feature feature) {
        this.key = feature;
    }

    public Feature getKey() {
        return this.key;
    }

    public int getFeatureIndex() {
        return this.key.getIndex();
    }

    public String getFeatureName() {
        return this.key.getName();
    }

    public int getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(int featureType) {
        this.featureType = featureType;
    }

    public int getParentIndex() {
        return this.parentIndex;
    }

    public void setParentIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        if (minValue != null && !minValue.isEmpty()) {
            this.minValue = Integer.parseInt(minValue);
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        if (maxValue != null && !maxValue.isEmpty()) {
            this.maxValue = Integer.parseInt(maxValue);
        }
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue != null && !defaultValue.isEmpty()) {
            this.defaultValue = Integer.parseInt(defaultValue);
        }
    }

    public int getOverheadRanking() {
        return this.overheadRanking;
    }

    public void setOverheadRanking(String overheadRanking) {
        if (overheadRanking != null && !overheadRanking.isEmpty()) {
            this.overheadRanking = Integer.parseInt(overheadRanking);
        }
    }

    public List<String> getPageList() {
        return this.pageList;
    }

    public List<String> getChartList() {
        return this.chartList;
    }

    public void makePageList(String data) {
        if (data != null && !data.isEmpty()) {
            String[] list = data.split("-");
            int i = 0;
            while (i < list.length) {
                this.pageList.add(list[i]);
                ++i;
            }
        }
    }

    public void makeChartList(String data) {
        if (data != null && !data.isEmpty()) {
            String[] list = data.split("-");
            int i = 0;
            while (i < list.length) {
                this.chartList.add(list[i]);
                ++i;
            }
        }
    }

    public String validateInputValue(String value) {
        if (value == null || value.isEmpty()) {
            return ConfigureLabels.FEATURE_DETAIL_VALUE_WARNING_FOR_EMPTY;
        }
        if (!AnalyzerUtil.isInteger(value)) {
            return ConfigureLabels.FEATURE_DETAIL_VALUE_WARNING_FOR_CHARACTER;
        }
        int iValue = Integer.parseInt(value);
        if (iValue < this.minValue || this.maxValue < iValue) {
            return ConfigureLabels.FEATURE_DETAIL_VALUE_WARNING_FOR_OUT_OF_RANGE.replace("minValue", String.valueOf(this.minValue)).replace("maxValue", String.valueOf(this.maxValue));
        }
        if (this.key.getIndex() == Feature.SYSTEM_SAMPLING_RATE.getIndex() && iValue % 10 != 0) {
            return ConfigureLabels.FEATURE_DETAIL_VALUE_WARNING_FOR_HAVE_TO_SET_MULTIPLE_OF_10MS_IN_SYSTEM_SAMPLING_RATE;
        }
        return "";
    }

    public String getOverheadRankingMessage() {
        String ret = "";
        switch (this.overheadRanking) {
            case 1: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_NORMAL;
                break;
            }
            case 2: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_MIDDLE;
                break;
            }
            case 3: {
                ret = ConfigureLabels.FEATURE_OVERHEAD_RANKING_HIGH;
                break;
            }
        }
        return ret;
    }

    public Color getOverheadRankingFontColor() {
        Color ret = ColorResources.FEATURE_OVERHEAD_RANKING_NORMAL;
        switch (this.overheadRanking) {
            case 1: {
                ret = ColorResources.FEATURE_OVERHEAD_RANKING_NORMAL;
                break;
            }
            case 2: {
                ret = ColorResources.FEATURE_OVERHEAD_RANKING_MIDDLE;
                break;
            }
            case 3: {
                ret = ColorResources.FEATURE_OVERHEAD_RANKING_HIGH;
                break;
            }
        }
        return ret;
    }
}

