/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.util.HashMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.nl.PreferencesDialogLabels;

public enum FlatPreferences {
    SOURCE_VIEW(2001, 0, PreferencesDialogLabels.SOURCE_VIEW),
    SYSTEM_SAMPLING_RATE(2002, 1000, PreferencesDialogLabels.SYSTEM_SAMPLIING_RATE),
    FUNCTION_SAMPLING_RATE(2003, 10, PreferencesDialogLabels.FUNCION_SAMPLIING_RATE),
    RECORDING(2004, 1, PreferencesDialogLabels.RECORDING),
    SCREENSHOT_PERIODICALLY(2006, 0, PreferencesDialogLabels.PERIODICALLY),
    SCREENSHOT_ON_SCENE_TRANSITION(2007, 1, PreferencesDialogLabels.ON_SCENE_TRANSITION),
    FUNCTION_PROFILING(3001, 1, PreferencesDialogLabels.FUNCTION_PROFILING),
    APP_STARTUP(3002, 1, PreferencesDialogLabels.APP_STARTUP),
    WEB_FUNCTION_PROFILING(3003, 1, PreferencesDialogLabels.WEB_FUNCTION_PROFILING),
    WEBAPP_STARTUP(3004, 1, PreferencesDialogLabels.WEBAPP_STARTUP),
    SYSTEM_ALL_PROCESSES(3005, 1, PreferencesDialogLabels.WEBAPP_STARTUP),
    PROCESS_MEMORY(3006, 1, PreferencesDialogLabels.PROCESS_MEMORY),
    LEAK_SANITIZER(4001, 0, PreferencesDialogLabels.LEAK_SANITIZER);

    private static final Map<Integer, FlatPreferences> featureByIndex;
    private static final Map<String, FlatPreferences> featureByName;
    private int index = 0;
    private String name = null;
    private int data = -1;
    private int defaultdata = -1;

    static {
        featureByIndex = new HashMap<Integer, FlatPreferences>();
        featureByName = new HashMap<String, FlatPreferences>();
        FlatPreferences[] flatPreferencesArray = FlatPreferences.values();
        int n = flatPreferencesArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlatPreferences feature = flatPreferencesArray[n2];
            int index = feature.getIndex();
            String name = feature.getName();
            featureByIndex.put(index, feature);
            featureByName.put(name, feature);
            ++n2;
        }
    }

    private FlatPreferences(int index, int defaultvalue, String name) {
        this.index = index;
        this.defaultdata = defaultvalue;
        this.name = name;
        this.data = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(int value) {
        this.data = value;
    }

    public int getValue() {
        return this.data;
    }

    public int getDefaultValue() {
        return this.defaultdata;
    }

    public static FlatPreferences getFlatPreferences(String name) {
        if (!featureByName.containsKey(name)) {
            return null;
        }
        return featureByName.get(name);
    }

    public static FlatPreferences getFlatPreferences(int featureIndex) {
        if (!featureByIndex.containsKey(featureIndex)) {
            return null;
        }
        return featureByIndex.get(featureIndex);
    }
}

