/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.setting.SettingConstants;
import org.tizen.dynamicanalyzer.util.CommonUtil;
import org.tizen.dynamicanalyzer.util.Logger;

public enum UILayoutDataManager {
    INSTANCE;

    private boolean isDirty = false;
    private Set<String> defaultChartSet = new HashSet<String>();
    private Set<String> selectedChartSet = new HashSet<String>();

    private UILayoutDataManager() {
        if (SettingConstants.SettingFilePath == null) {
            SettingConstants.SettingFilePath = String.valueOf(PathManager.DA_CONFIG_FOLDER_PATH) + File.separator;
        }
        this.readLayoutFile();
    }

    public void readLayoutFile() {
        block10: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "layout");
            BufferedReader in = null;
            String content = null;
            try {
                in = new BufferedReader(new FileReader(csv));
                while ((content = in.readLine()) != null) {
                    int i;
                    String[] list = content.split("\\|");
                    if (list[0].equals("Selected Chart List")) {
                        i = 1;
                        while (i < list.length) {
                            this.selectedChartSet.add(list[i]);
                            ++i;
                        }
                        continue;
                    }
                    if (!list[0].equals("Default Chart List")) continue;
                    i = 1;
                    while (i < list.length) {
                        this.defaultChartSet.add(list[i]);
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logger.exception((Throwable)e);
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block10;
            }
            catch (IOException e) {
                try {
                    Logger.exception((Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.tryClose((Object[])new Object[]{in});
                    throw throwable;
                }
                CommonUtil.tryClose((Object[])new Object[]{in});
                break block10;
            }
            CommonUtil.tryClose((Object[])new Object[]{in});
        }
    }

    private void writeLayoutFile() {
        block5: {
            File csv = new File(String.valueOf(SettingConstants.SettingFilePath) + "layout");
            FileWriter fileWriter = null;
            BufferedWriter buffWriter = null;
            PrintWriter printWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(csv);
                    buffWriter = new BufferedWriter(fileWriter);
                    printWriter = new PrintWriter(buffWriter);
                    printWriter.println(this.writeCollection(this.selectedChartSet, "Selected Chart List"));
                    printWriter.println(this.writeCollection(this.defaultChartSet, "Default Chart List"));
                    printWriter.checkError();
                }
                catch (IOException e) {
                    Logger.exception((Throwable)e);
                    CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
                    break block5;
                }
            }
            catch (Throwable throwable) {
                CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
                throw throwable;
            }
            CommonUtil.tryClose((Object[])new Object[]{fileWriter, buffWriter, printWriter});
        }
    }

    private <T> String writeCollection(Collection<T> collection, String key) {
        StringBuffer subBuffer = new StringBuffer();
        for (T element : collection) {
            if (subBuffer.length() > 0) {
                subBuffer.append("|");
            }
            subBuffer.append(element.toString());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(key);
        buffer.append("|");
        buffer.append(subBuffer);
        return buffer.toString();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public Set<String> getDefaultChartSet() {
        return Collections.unmodifiableSet(this.defaultChartSet);
    }

    public Set<String> getSelectedChartSet() {
        return Collections.unmodifiableSet(this.selectedChartSet);
    }

    public void setSelectedChartSet(Collection<String> selectedChartList) {
        this.selectedChartSet.clear();
        this.selectedChartSet.addAll(selectedChartList);
        this.writeLayoutFile();
    }

    public boolean addSelectedChart(String chartName) {
        boolean ret = this.selectedChartSet.add(chartName);
        this.writeLayoutFile();
        return ret;
    }

    public boolean removeSelectedChart(String chartName) {
        boolean ret = this.selectedChartSet.remove(chartName);
        this.writeLayoutFile();
        return ret;
    }
}

